/*------------------------------------------------------------------------------*
 * File Name: GraphicalExport.c													*
 * Creation: Sim 08-27-2007														*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * Sim 09-21-2007 DO_NOT_CHANGE_SETTING_WHEN_LAST_USED_THEME					*
 *	ML 10/11/2007 QA70-10519 DESTROY_AFTER_EXPORT								*
 *	CPY 10/11/07 QA70-10520 BAD_CODE_WITH_INFO_NOT_CENTRALIZED_LEAD_TO_FAILED_OK_ENABLED
 * CPY 10/11/07 QA70-10520 POOR_USE_OF_STATIC_LEAD_TO_PERSISTENT_OK_NOT_ENABLED_AFTER_NEW_OPJ
 * Sim 10-12-2007 QA70-10520 CENTRALIZE_MAKE_PAGE_SHORT_LONG_NAME				*
 *	Hong 10/22/07 QA80-10364 SHOW_ERROR_MSG_IN_PREVIEW_IF_FAIL					*
 *	Hong 10/24/07 QA80-10364-P6 FIX_EXECUTE_FAIL_GET_GUI_SETTING				*
 *	Folger 11/23/07 SHOULD_NOT_ALWAYS_SPECIFY_THE_FIRST_SELECTION				*
 *	Folger 12/05/07 LOCALIZED_COMBO_STRING_DEFAULT_SELECTION					*
 *	Folger 12/11/07 SHOULD_INIT_FILENAME_LIST_AND_THEME_LIST_WHEN_CHANGE_THEME	*
 *	Hong 12/25/07 QA80-10364 FIX_THEME_CHANGE_BROKEN_EXPORT						*
 *	Sim 12-26-2007 QA80-10364-P10 FIX_THEME_CHANGE_BROKEN_EXPORT				*
 *	Folger 02/03/08 QA80-11008 CHECK_TREENODE_AUTO_ATTRRIBUTE_BEFORE_UPDATE_VALUE
 *	Folger 02/15/08 QA80-11007 MOVE_EXPORT_GRAPH_MAKE_TREE_TO_VC				*
 *	Hong 03/03/08 v8.0816 IMPROVE_CODE_MORE_VALID_CHECK_THEME_APPLY				*
 *	Folger 03/12/08 APPLY_NEW_DEFAULT_THEME_MECHANISM_FOR_GRAPH_EXPORT			*
 *	YuI 05/20/08 QA70-11570 PAGE_EXPORT_FAILS_IF_LONG_NAME_PRESENT				*
 *	Sim 05-30-2008 FIX_ERRMSG_EXP_IMAGE											*
 *	Jasmine 07/15/08 QA80-11845 ENABLE_READONLY_SCROLL_FOR_MULTI_EDIT			*
 *	Sim 09-05-2008 CLEAN_DEFAULT_THEME											*
 *	Kyle 11/13/2008 QA80-12528 SUPPORT_APPLY_BUTTON_IN_EXPORT_GRAPH_DIALOG		*
 *  Iris 11/17/2008 v8.0973 QA80-12597 FIX_CANNOT_EXPORT_GRAPH_IF_UNIT_IS_POINT_OR_MM*
 *	Sim 12-23-2008 QA80-12836 SUPPORT_FILE_BROWSER_BUTTON						*
 *	Sim 12-24-2008 QA80-12853 FIX_SHOW_RASTER_IMAGE_PIXEL_SIZE_WHEN_RATIO_UNIT	*
 *	Sim 12-24-2008 QA80-12853 FIX_NOT_UPDATE_RASTER_IMAGE_PIXEL_SIZE_WHEN_CHANGE_HEIGHT
 *	Sim 01-04-2008 QA80-12853-P4 FIX_NOT_UPDATE_RASTER_IMAGE_PIXEL_SIZE_WHEN_CHANGE_MARGIN_OR_BORDER_WIDTH
 *	Hong 04/17/09 QA80-13280 SUPPORT_EXPORT_MULTI_PAGES_PDF						*
 *	Sim 05-07-2009 QA80-13571 FIX_CRASH_WHEN_FILE_PATH_LENGTH_IS_TOO_LONG		*
 *	Folger 05/12/09 QA80-13571-P1-P2 EXPORT_GRAPH_WITH_VERY_LONG_PATH_CRASH_ORIGIN
 *	Hong 06/01/09 REMOVE_BINARY_STORAGE_AFTER_EXPGRAPH_WHICH_IS_NOT_USED_ANYMORE*
 *	Hong 06/17/09 QA80-13280 EXPORT_MULTI_PAGES_PDF_MORE_PRINT_OPTIONS			*
 *	Hong 06/17/09 QA80-13280 HIDE_OPTION_NO_NEED_FOR_EXPORT_MULTI_PAGES_PDF		*
 *	Sim 07-13-2009 QA81-13923 FIX_EXP_GRAPH_FAILED_WHEN_LONG_NAME_CONTAIN_ONLY_ONE_DOUBLE_QUOTATION_MARK
 *	Sim 07-14-2009 QA81-13935-P1 SUPPORT_EXPORT_ALL_SHORTCUT_PAGE_IN_FOLDER		*
 *	Hong 07/21/09 QA80-13280-P4 WKS_EXPORT_MULTIPAGE_PDF_PAGE_BREAKS			*
 *	Hong 07/22/09 QA80-13935 MOVE_PRINT_OPTION_TO_HIGHER_LEVEL					*
 *	Hong 07/23/09 QA80-13935 HIDE_EXPORT_SETTING_BRANCE_FOR_EXPORT_MULTI_PAGES_PDF
 *	Hong 08/10/09 QA90-13280 SHOULD_REMOEV_PROJECT_TREE_AFTER_USED				*
 *	Hong 08/10/09 QA80-13280 IMRPOVE_EXP_MULTI_PDF_FONT_NAME_USE_FONT_LIST_CONTROL
 *	Hong 09/11/09 QA80-13280-S2 MAKE_PRINT_OPTS_READONLY_IF_NOT_USED			*
 *	Folger 09/14/09 QA80-14314 EXPORT_GRAPH_SUPPORT_READ_DEFAULT_IMAGE_TYPE_FROM_TOOLS_OPTION
 *	Hong 09/18/09 QA80-13280-P11 FIX_MARGIN_SETTING_NOT_USED_IN_EXP_PDF_PAGE	*
 *	Sim 09-21-2009 FIX_OPEN_EXP_WKS_RUNTIME_ERROR_IF_NO_WKS_ACTIVE				*
 *  Iris 9/29/2009 QA80-14386-P1 CHANGE_LABEL_TO_PAGE_NUMBERING					*
 *	Sim 09-29-2009 QA80-14386-P3 AUTO_RENAME_JUST_NEED_ASK_ONE_TIMES			*
 *	Sim 10-10-2009 QA81-14406-P1 TRUN_OFF_TIFF_PREVIEW_IN_EPS_EXPORT_BY_DEFAULT	*
 *	Hong 10/13/09 QA80-13280-S3 BETTER_PREDEFINE_FILE_NAME_LABEL_FOR_WKS		*
 *	Folger 10/28/09 QA81-14541 SYSTEM_DEFAULT_FILE_EXTENSION_TEMP_CHANGE_SUPPORT*
 *	Hong 10/30/09 QA80-14562 EXP_MULTI_PAGE_PDF_SUPPORT_ORIENTATION_OPTION		*
 *	Kyle 01/28/2010 QA80-15041 WANT_ENABLE_GRAPH_CURRENT_SPEED_MODE_FOR_EXPORT	*
 *	Kyle 07/07/2010 ORG-338-P1 AUTO_WIDTH_HEIGHT_FOR_EXPORT_GRAPH				*
 *	Kyle 07/12/2010 ORG-338-P2 WHOLE_PAGE_INSTEAD_OF_CLIPPED_AREA_IS_EXPORTED_WHEN_MARGIN_CONTROL_IS_TIGHT_ETC
 *	Kyle 07/28/2010 ORG-666-S1 USE_FULL_RESOLUTION_TO_EXPORT_WATERFALL_GRAPH	*
 *	Kyle 07/30/2010 ORG-674-P1 EXPORT_LAYOUT_SHOULD_NOT_APPLY_THE_THEME_FOR_GRAPH
 *	Kyle 08/23/2010 ORG-338-S1 SHOW_PAGE_ORIGINAL_SIZE_AS_HINT					*
 *	Kyle 08/24/2010 ORG-338-P4 UPDATE_AUTO_WIDTH_AND_HEIGHT_ON_RESCALING_CHANGE	*
 *	Kyle 08/24/2010 ORG-338-P3 INIT_PAGE_DEFAULT_SETTING_ON_AFTER_LOAD_SYSTEM_DEFAULT
 *	Folger 09/25/2010 ORG-1123-P1 INDEX_OF_ANNOTATION_LOST_IN_EXPORT_GRAPH		*
 *	Sophy 10/18/2010 ORG-1276 PROPER_SHOW_RESULT_MESSAGE_ON_PAGE_EXPORT			*
 *------------------------------------------------------------------------------*/
 
////////////////////////////////////////////////////////////////////////////////////
// Including the system header file Origin.h should be sufficient for most Origin
// applications and is recommended. Origin.h includes many of the most common system
// header files and is automatically pre-compiled when Origin runs the first time.
// Programs including Origin.h subsequently compile much more quickly as long as
// the size and number of other included header files is minimized. All NAG header
// files are now included in Origin.h and no longer need be separately included.
//
// Right-click on the line below and select 'Open "Origin.h"' to open the Origin.h
// system header file.
#include <Origin.h>
////////////////////////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////////////////////////
// Include your own header files here.
#include <xfutils.h>
#include <image_utils.h>
#include <GetNBox.h>
#include <..\originlab\theme_utils.h>
#include "GraphicalExport.h"
#include <control.h>
#include <ocGDI.h> //------- CPY 10/6/06 EMF_PREVIEW
#include <okocUtils.h>
#include <..\originlab\grobj_utils.h> /// Hong 11/05/07 v8.0740 FIX_EXP_GRAPH_FAIL_WITH_AXIS_SCROLLBAR

////////////////////////////////////////////////////////////////////////////////////
// Start your functions here.
#define		MAX_PIXEL					25000000  /// Iris 11/09/06 NOT_SHOW_PREVIEW_IF_PIXEL_TOO_LARGE

#define		NUM_ORIGINAL_SIZE			"ActualSize"
#define		STR_ORIGINAL_UNIT_ATTRIB	"PageUnit" /// Iris 10/11/06 v8.0494b GET_PAGE_SIZE_AND_UNIT_FROM_THEME
#define		STR_UNIT_ATTRIB				"Unit" 
#define		STR_RATIO_ATTRIB			"Ratio"
#define		STR_PIXEL_WIDTH				"PixelWid"
#define		STR_PIXEL_HEIGHT			"PixelHei"

//#define		STR_GUI_UNIT_COMBO			"inch|cm|pixel|ratio"

//#define		STR_NEED_UPDATE_ATTRIB			"NeedUpdate"	///Jasmine 04/25/07 ADD_UPDATE_PREVIEW_BUTTON 

#define		STR_COMBO_LAYOUT			_L("Active Page|All in Active Folder|All in Active Folder (Recursive)|All in Active Folder (Open)|All in Project|Specified")	//------ Folger 07/31/07 NOT_SHOW_INCLUDE_EMEBEDED_OPTION_FOR_LAYOUT_BROWSE

#define		STR_CURRENT_SIZE			_L("Width: %.2f inch, Height: %.2f inch") ///---Sim 08-22-2007 SHOW_CURRENT_SIZE_WHEN_CHANGE_PERCENT
/// Hong 10/19/07 v8.0728 IMPROVE_AND_CENTRALIZE_CODE
#define		DEFAULT_RESOLUTION			96
/// Hong 11/09/07 v8.0744 MORE_LOCALIZED_WITH_E_VERSION_NEEDED
//#define		STR_DEFAULT_THEME				"<Original>"
#define		STR_DEFAULT_THEME_E				_LE("<Original>")
#define		STR_DEFAULT_THEME				GetLocalized(STR_DEFAULT_THEME_E)
/// end MORE_LOCALIZED_WITH_E_VERSION_NEEDED
#define		DEFAULT_DECIMAL_PLACES		2
/// end IMPROVE_AND_CENTRALIZE_CODE

enum
{
	UNIT_INCH = 0,
	UNIT_CM,
	UNIT_MM,
	UNIT_PIXEL,
	UNIT_POINT,
	UNIT_RATIO
};

// the options of Unit node on dialog
enum
{
	GUI_UNIT_INCH = 0,
	GUI_UNIT_CM,
	GUI_UNIT_PIXEL,
	GUI_UNIT_RATIO
};

#define	DEFAULT_UNIT_INCH 		UNIT_INCH   	/// Iris 11/17/2008 v8.0973 QA80-12597 FIX_CANNOT_EXPORT_GRAPH_IF_UNIT_IS_POINT_OR_MM

enum{ // overwrite option
	///---Sim 09-29-2009 QA80-14386-P3 AUTO_RENAME_JUST_NEED_ASK_ONE_TIMES
	//c_overwrite_rename,
	c_overwrite_cancel = -1,
	c_overwrite_rename = 0,
	///---END QA80-14386-P3 AUTO_RENAME_JUST_NEED_ASK_ONE_TIMES
	c_overwrite_replace,
	c_overwrite_skip,
	c_overwrite_ask,
};

enum //Page Settings
{
	PAGE_RATIO = 101,
	PAGE_MARGIN_CONTROL,
	PAGE_BRODER_WIDTH,
	PAGE_SIZE_TYPE,
	PAGE_SIZE,
	PAGE_RESOLUTION,
	PAGE_WIDTH_SCALE,
	PAGE_HEIGHT_SCALE,
	PAGE_UNIT,	
	PAGE_RESCALING,
	PAGE_WIDTH,	
	PAGE_HEIGHT,
	PAGE_PIXEL_SIZE,
	PAGE_THEME,
	PAGE_KEEP_PREVIEW,
 	PAGE_CUR_SIZE, ///---Sim 08-22-2007 SHOW_CURRENT_SIZE_WHEN_CHANGE_PERCENT
 	PAGE_EXPORT_AREA,
	
	PAGE_LAST_ITEM	
};

///---Sim 06-30-2007 CLEAR_CODE
enum
{
	rescaling_width = 0,
	rescaling_height
};
///---END CLEAR_CODE

///Kyle 01/28/2010 QA80-15041 WANT_ENABLE_GRAPH_CURRENT_SPEED_MODE_FOR_EXPORT
enum
{
	SPEED_MODE_AUTO,
	SPEED_MODE_ON,
	SPEED_MODE_OFF
};
///End WANT_ENABLE_GRAPH_CURRENT_SPEED_MODE_FOR_EXPORT

/// Hong 06/17/09 QA80-13280 EXPORT_MULTI_PAGES_PDF_MORE_PRINT_OPTIONS
#ifdef		SUPPORT_EXPORT_MULTI_PAGES_PDF
	typedef void (*FUNC_CONSTRUCT_PRINT_OPTION_TREE)(TreeNode &tr, DWORD dwSet, double dLeft, double dRight, double dTop, double dBottom, bool bHideForExport = false);
	typedef bool (*FUNC_APPLY_PRINT_OPTIONS)(const TreeNode& trGetNPrintOpts, Worksheet& wks);
	typedef bool (*FUNC_APPLY_WKS_PRINT_OPTIONS)(Worksheet& wks, TreeNode& trGetNPrintOpts); /// Hong 07/21/09 QA80-13280-P4 WKS_EXPORT_MULTIPAGE_PDF_PAGE_BREAKS
	
#define		STR_PRINT_FUNCTION_FILE			"Originlab\\commonDlgs.c"

static bool _get_print_opts(TreeNode& tr)
{
	FUNC_CONSTRUCT_PRINT_OPTION_TREE pfn = Project.FindFunction("construct_print_option_tree", STR_PRINT_FUNCTION_FILE);	
	if ( !pfn )
		return false;
	DWORD		dwSet = GPC_BACKGROUND | GPC_FRAME;
	/// Hong 07/21/09 QA80-13280-P4 WKS_EXPORT_MULTIPAGE_PDF_PAGE_BREAKS
	//pfn(tr, dwSet, 0, 0, 0, 0, TRUE);
	pfn(tr, dwSet, 0, 0, 0, 0, FALSE);
	/// end WKS_EXPORT_MULTIPAGE_PDF_PAGE_BREAKS
	/// Hong 11/03/09 QA80-14562 REMOVE_PAGE_SETUP_RELATIVE_OPTIONS_FROM_EXPORT_GUI
	ASSERT(tr.Margin);
	if ( tr.Margin )
		tr.Margin.Show = false;
	/// end REMOVE_PAGE_SETUP_RELATIVE_OPTIONS_FROM_EXPORT_GUI
	return true;
}

/// Hong 07/21/09 QA80-13280-P4 WKS_EXPORT_MULTIPAGE_PDF_PAGE_BREAKS
static bool _apply_wks_print_opts_to_tree(Worksheet& wks, TreeNode& trGetNPrintOpts)
{
	FUNC_APPLY_WKS_PRINT_OPTIONS pfn = Project.FindFunction("apply_wks_print_options", STR_PRINT_FUNCTION_FILE);	
	if ( !pfn )
		return false;
	return pfn(wks, trGetNPrintOpts);
}

static void _set_treenode_inc_dataid(TreeNode& tr, int& nDataID, bool bRecursive = true)
{
	int		nUse;
	if ( tr.GetAttribute(STR_USE_ATTRIB, nUse) )
		tr.DataID = nDataID++;
	foreach ( TreeNode trNode in tr.Children )
	{
		if ( !trNode.FirstNode )
			trNode.DataID = nDataID++;
		else if ( bRecursive )
			_set_treenode_inc_dataid(trNode, nDataID, bRecursive);
	}
}

/// Hong 09/18/09 QA80-13280-P11 FIX_MARGIN_SETTING_NOT_USED_IN_EXP_PDF_PAGE
static void _construct_dimension_tree(TreeNode& trPDFSettings, const TreeNode& trPrintOpts)
{
	ASSERT(trPrintOpts.Margin);
	TreeNode		trDim = trPDFSettings.AddNode("Dimensions");
	TreeNode		trMargin = trPrintOpts.Margin;
	trDim.Units.nVal = trMargin.Use;
	trDim.AddNode(trMargin);
	/// Hong 10/03/09, replaced by RVD 11/2/2009 qa70-14562-p1 MULTIPDF_EXPORT_SHARED_ORIENTATION
	/*
	/// Hong 10/30/09 QA80-14562 EXP_MULTI_PAGE_PDF_SUPPORT_ORIENTATION_OPTION
	TreeNode		trOrientation = trPrintOpts.Orientation;
	ASSERT(trOrientation);
	trPDFSettings.AddNode(trOrientation);
	/// end EXP_MULTI_PAGE_PDF_SUPPORT_ORIENTATION_OPTION
	*/
	/// end ---
}
/// end FIX_MARGIN_SETTING_NOT_USED_IN_EXP_PDF_PAGE

/// end WKS_EXPORT_MULTIPAGE_PDF_PAGE_BREAKS

#endif		//SUPPORT_EXPORT_MULTI_PAGES_PDF

/// Hong 11/01/07 v8.0738 CLEAN_ERROR_MSG_MACHNISM
/*
static bool s_bValidPath = true;
static bool s_bValidFileName = true;
static bool s_bValidWidth = true;
static bool s_bValidSourcePage = true;
static bool s_bValidPreview = true;
static bool s_bNoDuplicateFileName = true; ///---Sim 08-17-2007 CHECK_DUPLICATE_FILE_NAMES
static bool s_bNoHierarchySheet = true;

static string s_strErrWidth;
static string s_strErrPath;
static string s_strErrPreview;

//---- CPY 10/11/07 QA70-10520 POOR_USE_OF_STATIC_LEAD_TO_PERSISTENT_OK_NOT_ENABLED_AFTER_NEW_OPJ
// should replace all statics with a single structure and assume all default should be 0 or empty so it is simple to reset it here
// but I have to init them one by one for now
static void _init_all_statics()
{
	s_bValidPath = true;
	s_bValidFileName = true;
	s_bValidWidth = true;
	s_bValidSourcePage = true;
	s_bValidPreview = true;
	s_bNoDuplicateFileName = true;
	s_bNoHierarchySheet = true;
	s_strErrWidth.Empty();
	s_strErrPath.Empty();
	s_strErrPreview.Empty();
}
//---- end POOR_USE_OF_STATIC_LEAD_TO_PERSISTENT_OK_NOT_ENABLED_AFTER_NEW_OPJ

#define OK_SURE(_OK_ENABLE) _OK_ENABLE = (s_bValidPath && s_bValidFileName && s_bValidWidth && s_bValidSourcePage);

static void _get_error_message(string& strErrMsg)
{
	strErrMsg = CER_NO_ERROR;
	
	if ( !s_bValidSourcePage )
	{
		strErrMsg = CER_INVALID_GRAPH;
		return;
	}
	
	if ( !s_bValidWidth )
	{
		strErrMsg = s_strErrWidth;
		return;
	}
	
	if ( !s_bValidFileName )
	{
		strErrMsg = CER_INVALID_FILENAME;
		return;
	}

	if ( !s_bValidPath )
	{
		strErrMsg = s_strErrPath;
		return;
	}

	if ( !s_bValidPreview )
	{
		strErrMsg = s_strErrPreview;
		return;
	}
	
	///---Sim 08-17-2007 CHECK_DUPLICATE_FILE_NAMES
	if ( !s_bNoDuplicateFileName )
	{
		strErrMsg = CER_DUPLICATE_FILE_NAME;
		return;
	}
	///---END CHECK_DUPLICATE_FILE_NAMES
	
	if ( !s_bNoHierarchySheet )
	{
		strErrMsg = EXPWARN_WKS_NOT_SUPPORT_RESULT_SHEET;
		return;
	}
}
///---END CHECK_ERROR_ON_INDIVIDUAL_EVENT_ITSELF
*/
/// end CLEAN_ERROR_MSG_MACHNISM

////////////////////////////////////////////////////////////////////
///  SaveRestorePageSettings
//////////////////////////////////////////////////////////////////
class SaveRestorePageSettings
{
public:
	SaveRestorePageSettings()
	{
	    // save here
		OriginSettings os;
		os.GetValue("CopyPage.Closeness", m_nMarge);
		os.GetValue("CopyPage.ClipBorderw", m_nBorderWidth);
		os.GetValue("CopyPage.ADVANCED", m_nAdvanced);		
		os.GetValue("CopyPage.ADVKEEPSIZE", m_nKeepSize);
		os.GetValue("CopyPage.ADVRES", m_nDPI);
		os.GetValue("CopyPage.RATIO", m_dRatio);	
		//printf("store: nMarge:%d  nBorderWidth:%d  nAdvanced:%d\n", m_nMarge, m_nBorderWidth, m_nAdvanced);
	}
	
	~SaveRestorePageSettings()
	{
	   // restore here
		OriginSettings os;
		os.SetValue("CopyPage.Closeness", m_nMarge);
		os.SetValue("CopyPage.ClipBorderw", m_nBorderWidth);
		os.SetValue("CopyPage.ADVANCED", m_nAdvanced);		
		os.SetValue("CopyPage.ADVKEEPSIZE", m_nKeepSize);
		os.SetValue("CopyPage.ADVRES", m_nDPI);
		os.SetValue("CopyPage.RATIO", m_dRatio);	
		//printf("restore: nMarge:%d  nBorderWidth:%d  nAdvanced:%d\n", m_nMarge, m_nBorderWidth, m_nAdvanced);
	}
	
private:
// put settings saving data here
	int 	m_nMarge;
	int		m_nBorderWidth;
	int		m_nAdvanced;
	int		m_nKeepSize;
	int		m_nDPI;
	double		m_dRatio;
};

///Kyle 01/28/2010 QA80-15041 WANT_ENABLE_GRAPH_CURRENT_SPEED_MODE_FOR_EXPORT
////////////////////////////////////////////////////////////////////
///  SaveRestoreGraphPageSettings
//////////////////////////////////////////////////////////////////
class SaveRestoreGraphPageSettings : public SaveRestorePageSettings
{
public:
	SaveRestoreGraphPageSettings()
	{
	}

	SaveRestoreGraphPageSettings(GraphPage& gp)
	{
	    // save here
	    m_gp = gp;
	    if ( m_gp )
			m_bIsUseSpeedModeForExport = m_gp.IsUseSpeedModeForExport();
	}

	~SaveRestoreGraphPageSettings()
	{
	   // restore here
	    if ( m_gp )
	    	m_gp.SetUseSpeedModeForExport(m_bIsUseSpeedModeForExport);
	}

private:
// put settings saving data here
	bool		m_bIsUseSpeedModeForExport;
	GraphPage	m_gp;
};
///End WANT_ENABLE_GRAPH_CURRENT_SPEED_MODE_FOR_EXPORT

////////////////////////////////////////////////////////////////////
///  SaveRestoreWksPageSettings
//////////////////////////////////////////////////////////////////
class SaveRestoreWksPageSettings : public SaveRestorePageSettings
{
public:
	SaveRestoreWksPageSettings()
	{
	}
	
	SaveRestoreWksPageSettings(Worksheet& wks)
	{
	    // save here
	    m_wks = wks;
	    if ( m_wks )
			m_bStorePrintArea = m_wks.GetPrintArea(&m_rngPrintArea);
	}
	
	~SaveRestoreWksPageSettings()
	{
	   // restore here
	    if ( m_wks )
	    {
			if ( m_bStorePrintArea )
				m_wks.SetPrintArea(&m_rngPrintArea);
			else
				m_wks.SetPrintArea(NULL); // clear
	    }
	}
	
private:
// put settings saving data here
	ORANGE	m_rngPrintArea;
	bool	m_bStorePrintArea;
	
	Worksheet m_wks;
};


////////////////////////////////////////////////////////////////////
///  ImageFileList
//////////////////////////////////////////////////////////////////
class ImageFileList
{
public:
	bool InitImageTypeList(int nCtrl)
	{
		get_image_file_type_descrips_sorted_by_extension(m_saDescriptions, nCtrl);
		
		get_image_file_type_extensions_sorted(m_saExtensions, nCtrl);
		
		return m_saDescriptions.GetSize() > 0 && m_saExtensions.GetSize() > 0 ? true : false;
	}
	
	bool SetImageType(int nIndex)
	{
		if ( nIndex >= m_saDescriptions.GetSize() )
			return false;
		
		m_nIndex = nIndex;
		
		return true;;
	}
	
	int 	GetImageType() {return m_nIndex;}
	
	
	bool GetDescriptions(StringArray& saDescription)
	{
		if( 0 == m_saDescriptions.GetSize() )
			return false;
		
		saDescription = m_saDescriptions;
		return true;
	}
	
	bool GetExtensions(StringArray& saExtensions)
	{
		if( 0 == m_saExtensions.GetSize() )
			return false;
		
		saExtensions = m_saExtensions;
		return true;
	}
	
	bool GetDescription(string& strDescription, int nIndex)
	{
		if ( nIndex >= 0 && nIndex < m_saDescriptions.GetSize() )
		{
			strDescription = m_saDescriptions[nIndex];
			return true;
		}
		
		return false;
	}
	
	bool GetExtension(string& strExtension, int nIndex)
	{
		if ( nIndex >= 0 && nIndex < m_saExtensions.GetSize() )
		{
			strExtension = m_saExtensions[nIndex];
			return true;
		}
		
		return false;
	}
	
private:
	int 			m_nIndex;
	StringArray 	m_saDescriptions;
	StringArray		m_saExtensions;
};


//////////////////////////////////////////////////////////////////
///  CGraphicalExportBase
//////////////////////////////////////////////////////////////////
class CGraphicalExportBase
{
public:
	CGraphicalExportBase()
	{
	}
	
	~CGraphicalExportBase()
	{
	}		
		
	void 		SetFullFileName(LPCSTR lpcszFilename)
	{
		m_strFullFileName = lpcszFilename;
	}
	
	TreeNode	GetImageOptions()
	{ 
		return m_trImageOptions; 
	}
	
	void		SetImageOptions(const TreeNode& trImageOptions)
	{
		m_trImageOptions = trImageOptions;
	}

protected:
	TreeNode 		m_trImageOptions;
	
	string			m_strFullFileName;
};


//////////////////////////////////////////////////////////////////
///  CGraphicalExportImage
//////////////////////////////////////////////////////////////////
/* not implemented now
class CGraphicalExportImage : public CGraphicalExportBase
{
public:
	CGraphicalExportImage()
	{
	}
	
	~CGraphicalExportImage()
	{
	}
	
	virtual bool Export();

};
*/


//////////////////////////////////////////////////////////////////
///  CGraphicalExportPage
//////////////////////////////////////////////////////////////////
class CGraphicalExportPage : public CGraphicalExportBase
{
public:
	CGraphicalExportPage()
	{
	}	
	
	~CGraphicalExportPage()
	{
	}	
		
	virtual int		GetPageType()
	{
		if(m_pgSource)
			return m_pgSource.GetType();
		return -1;
	}		

	void		SetSourcePage(const Page& pg, int nIndex = 0)
	{
		m_pgSource = pg;
		m_nIndexLayer = nIndex;
	}
	
	bool 		SetExportSize(double dWidth, double dHeight, int nUnit, int nDPI)
	{
		if ( UNIT_PIXEL == nUnit )
		{
			m_nWidthPixel = dWidth;
			m_nHeightPixel = dHeight;
			m_nDPI = nDPI;
		}
		else if ( UNIT_RATIO == nUnit )
		{
			m_dRatio = dWidth;
		}
		else
		{
			// need to do
		}
		
		return true;
	}
	
protected:
	Page		m_pgSource;
	int			m_nIndexLayer;

	int			m_dRatio;
	int 		m_nWidthPixel, m_nHeightPixel;
	int			m_nDPI;
	
	int			m_nBitsPerPixel;
	int			m_nCompression;
	bool		m_bGray;
};


//////////////////////////////////////////////////////////////////
///  CGraphicalExportGraph
//////////////////////////////////////////////////////////////////
class CGraphicalExportGraph : public CGraphicalExportPage
{
public:
	//virtual
	int		GetPageType()
	{
		int		nType = EXIST_PLOT;
		
		Page 	pg = Project.Pages();
		if(pg)
		{
			nType = pg.GetType();
			if(EXIST_WKS == nType) //export embeded graph from worksheet
				nType = EXIST_PLOT;
		}
		return nType;		
	}
};



//////////////////////////////////////////////////////////////////
///  CGraphicalExportWks
//////////////////////////////////////////////////////////////////
class CGraphicalExportWks : public CGraphicalExportPage
{
public:
	CGraphicalExportWks()
	{
	}
	
	//virtual
	int		GetPageType()
	{
		return EXIST_WKS;
	}
};


//////////////////////////////////////////////////////////////////
///  CGraphicalExportBaseEx
//////////////////////////////////////////////////////////////////
class CGraphicalExportBaseEx
{
public:
	CGraphicalExportBaseEx()
	{
		m_IFL.InitImageTypeList(IFT_RASTER_AND_VECTOR);
	}
	
public:
	void 		SetFileName(LPCSTR lpcszFilename, DWORD dwOptions = 0)
	{
		m_strFileName = lpcszFilename;
	}
	
	void 		SetPath(LPCSTR lpcszPath)
	{
		m_strPath = lpcszPath;
	}
	
	void		SetOverWrite(int nType)
	{
		m_nOverWrite = nType;
	}
	
	string 		GetFileName(Page& pg, int nIndex = 0)
	{
		string strExt = GetImageTypeExtension();
	
		/// Hong 10/19/07 v8.0728 IMPROVE_AND_CENTRALIZE_CODE
		//return _check_get_full_path(nIndex, m_strPath, pg.GetName(), strExt, m_strFileName, m_nOverWrite);
		//return m_strPath + m_strFileName + "." + strExt;
		string strFileName(m_strFileName);
		LPSTR lpstr = strFileName.GetBuffer(MAXFULLPATH);
		check_add_file_ext(lpstr, strExt);
		strFileName.ReleaseBuffer();
		
		return m_strPath + strFileName;
		/// end IMPROVE_AND_CENTRALIZE_CODE
	}
	
////// for image type list
public:
	bool		SetImageType(int nType)
	{
		return m_IFL.SetImageType(nType);
	}
	
	int			GetImageType()
	{
		return m_IFL.GetImageType();
	}
	
	string 		GetImageTypeDescription()
	{
		string strDescription;
		m_IFL.GetDescription(strDescription, GetImageType());
		return strDescription;
	}
	
	string		GetImageTypeExtension()
	{
		string strExtension;
		m_IFL.GetExtension(strExtension, GetImageType());
		return strExtension;
	}
	
	bool		GetImageTypeDescriptions(StringArray &saDescriptions)
	{
		return m_IFL.GetDescriptions(saDescriptions);
	}
	
	bool		GetImageTypeExtensions(StringArray &saExtensions)
	{
		return m_IFL.GetExtensions(saExtensions);
	}
	
protected:
	bool		ConvertSize(double& dDestSize, int nDestUnit, double dSrcSize, int nSrcUnit, int* pnDPI = NULL)
	{
		if ( UNIT_RATIO == nDestUnit || UNIT_RATIO == nSrcUnit )
		return false;
		
		//int nDPI = 96;
		int nDPI = DEFAULT_RESOLUTION; /// Hong 10/19/07 v8.0728 IMPROVE_AND_CENTRALIZE_CODE
		if ( pnDPI )
			nDPI = *pnDPI;
		
		dDestSize =  _convert_size_to_specified_unit(dSrcSize, nSrcUnit, nDestUnit, nDPI);
		
		return true;
	}

	///--- not finish by sim
	//string		UnitIntToString(int nUnit);
	//int			UnitStringToInt(LPCSTR lpcszUnit);
	///---
	
protected:
	ImageFileList 	m_IFL;
	
	string			m_strFileName;
	string			m_strPath;
	int 			m_nOverWrite;
};

/// Hong 04/17/09 QA80-13280 SUPPORT_EXPORT_MULTI_PAGES_PDF
static void _multiply_subnodes(TreeNode& tr, double dFactor)
{
	if ( !tr )
		return ;
	
	foreach ( TreeNode trNode in tr.Children )
	{
		if ( trNode.FirstNode )
		{
			_multiply_subnodes(trNode, dFactor);
		}
		else if ( TRGP_DOUBLE == trNode.ID )
			trNode.dVal = trNode.dVal * dFactor;
	}
}

static bool _pdf_unit_event(TreeNode& tr, int nRow, int nCol, TreeNode& trNode, DWORD nEventInfo, int nCntrlType, WndContainer& getNContainer)
{
	if ( GETNEVENT_ON_INIT & nEventInfo || GETNEVENT_ON_THEME & nEventInfo )
	{
		if ( GETNEVENT_ON_THEME & nEventInfo )
			trNode.RemoveAttribute(STR_CHANGED_ATTRIB);
		return false;
	}
	
	if ( !(GETNEVENT_VIEW_LIST & nEventInfo) )
		return false;
	
	int				nOldVal;
	if ( trNode.GetAttribute(STR_CHANGED_ATTRIB, nOldVal) && nOldVal == trNode.nVal )
		return false;
	
	double			dFactor;
	if ( 1 == trNode.nVal )
		dFactor = 2.54;
	else
		dFactor = 1.0/2.54;
	_multiply_subnodes(trNode.Parent(), dFactor);
	trNode.SetAttribute(STR_CHANGED_ATTRIB, trNode.nVal);
	
	return true;
}
/// end SUPPORT_EXPORT_MULTI_PAGES_PDF

//////////////////////////////////////////////////////////////////
///  CGraphicalExportPageEx
//////////////////////////////////////////////////////////////////
class CGraphicalExportPageEx : public CGraphicalExportBaseEx
{
public:
	CGraphicalExportPageEx()
	{
		m_pExpPage = NULL;
		m_IFL.InitImageTypeList(IFT_RASTER_AND_VECTOR);
		/// Hong 11/01/07 v8.0738 CLEAN_ERROR_MSG_MACHNISM
		m_bValidPath = true;
		m_bValidFileName = true;
	 	m_bValidWidth = true;
	 	m_bValidSourcePage = true;
	 	m_bValidPreview = true;
	 	m_bNoDuplicateFileName = true; ///---Sim 08-17-2007 CHECK_DUPLICATE_FILE_NAMES
	 	m_bNoHierarchySheet = true;
	
	 	m_strErrWidth = "";
	 	m_strErrPath = "";
	 	m_strErrPreview = ""; 
	 	/// end CLEAN_ERROR_MSG_MACHNISM
	}
		
	virtual int		GetPageType()
	{
		if ( !m_pExpPage )
		{
			ASSERT(false);
			return EXIST_PLOT;
		}
		return m_pExpPage->GetPageType();
	}
	
	virtual void 	SetTarget(StringArray& saTargets)
	{
		// do nothing here, need redesign this function
	}

////// for GUI setting
public:
	/// Hong 11/01/07 v8.0738 CLEAN_ERROR_MSG_MACHNISM
	bool	IsOKSure()
	{
		return ( m_bValidPath && m_bValidFileName && m_bValidWidth && m_bValidSourcePage );
	}
	
	string GetErrorMessage()
	{
		string strErrMsg = CER_NO_ERROR;
	
		if ( !m_bValidSourcePage )
		{
			strErrMsg = CER_INVALID_GRAPH;
		}		
		else if ( !m_bValidWidth )
		{
			strErrMsg = m_strErrWidth;
		}		
		else if ( !m_bValidFileName )
		{
			strErrMsg = CER_INVALID_FILENAME;
		}
		else if ( !m_bValidPath )
		{
			strErrMsg = m_strErrPath;
		}
		else if ( !m_bValidPreview )
		{
			strErrMsg = m_strErrPreview;
		}
		///---Sim 08-17-2007 CHECK_DUPLICATE_FILE_NAMES
		else if ( !m_bNoDuplicateFileName )
		{
			strErrMsg = CER_DUPLICATE_FILE_NAME;
		}
		///---END CHECK_DUPLICATE_FILE_NAMES
		else if ( !m_bNoHierarchySheet )
		{
			strErrMsg = EXPWARN_WKS_NOT_SUPPORT_RESULT_SHEET;
		}
		
		return strErrMsg;
	}
	/// end CLEAN_ERROR_MSG_MACHNISM
	
	/// Hong 04/17/09 QA80-13280 SUPPORT_EXPORT_MULTI_PAGES_PDF
	//int 	InvokeOnMakeTree(TreeNode& tr, LPCSTR lpcszVarName)
	int 	InvokeOnMakeTree(TreeNode& tr, LPCSTR lpcszVarName, bool bMultiPgPDF = false)
	/// ennd SUPPORT_EXPORT_MULTI_PAGES_PDF
	{
		//------ Folger 02/15/08 QA80-11007 MOVE_EXPORT_GRAPH_MAKE_TREE_TO_VC
		/*
		///---Sim 06-20-2007 TEST_SPEED
		#ifdef _TEST_SPEED
		//Profiler pro; 
		show_time(NULL); 
		#endif // _TEST_SPEED
		///---END TEST_SPEED
		
		///Jasmine 04/23/07 MOVE_OUT_SYSTEM_SETTING_OPTION
		if( !lstrcmp(lpcszVarName, "tr") )
		{
			ConstructPageSettingsGUI(tr);

			///---Sim 06-20-2007 TEST_SPEED
			#ifdef _TEST_SPEED
			show_time("after make tree tr");
			#endif // _TEST_SPEED
			///---END TEST_SPEED
			return 0;
		}	
		///End MOVE_OUT_SYSTEM_SETTING_OPTION
		if( !lstrcmp(lpcszVarName, "tr1") )
		{
			_gui_construct_page_size_settings(tr);
		
			///---Sim 06-20-2007 TEST_SPEED
			#ifdef _TEST_SPEED
			show_time("after make tree tr1"); 
			#endif // _TEST_SPEED
			///---END TEST_SPEED
			return 0;
		}
		
		if( !lstrcmp(lpcszVarName, "tr2") )
		{
			export_gui_construct_options_branch(tr);
			///---Sim 06-20-2007 TEST_SPEED
			#ifdef _TEST_SPEED
			show_time("after make tree tr2");
			#endif // _TEST_SPEED
			///---END TEST_SPEED
			return 0;
		}
		
		return 1;
		*/
		/// Hong 04/17/09 QA80-13280 SUPPORT_EXPORT_MULTI_PAGES_PDF
		//return okutil_export_graph_construct_tree(&tr, lpcszVarName, GetPageType());
		int		nRet = okutil_export_graph_construct_tree(&tr, lpcszVarName, GetPageType());
		if ( 0 == nRet && bMultiPgPDF )
		{
			if ( 0 == lstrcmpi(lpcszVarName, "tr2") )
			{// Hong, to do, add NodeID later
				TreeNode trPDF = getPDFOptions(tr);
				if ( !trPDF )
					return 1;
				
				string		strExt = "PDF";
				int			nDataID = GET_USER_DATAID(1);
				GETN_USE(tr)
				GETN_BEGIN_BRANCH(MultiPage, _L("Multiple Pages")) GETN_CURRENT_NODE.SetAttribute(_get_additional_attrib_name(strExt), strExt);
					/// Hong 07/21/09 QA80-13280-P4 WKS_EXPORT_MULTIPAGE_PDF_PAGE_BREAKS
					/*
					GETN_BEGIN_BRANCH(Dimensions, _L("Dimensions"))
						GETN_LIST(Units, _L("Units"), 0, _L("inch|cm")) GETN_ID(nDataID++) GETN_OPTION_EVENT_EX(_pdf_unit_event)
						GETN_NUM(Width, _L("Width"), 8.5) GETN_ID(nDataID++)
						GETN_NUM(Height, _L("Height"), 11) GETN_ID(nDataID++)
						GETN_BEGIN_BRANCH(Margins, _L("Margins"))
							GETN_NUM(Left, _L("Left"), 0.75) GETN_ID(nDataID++)
							GETN_NUM(Right, _L("Right"), 0.75) GETN_ID(nDataID++)
							GETN_NUM(Top, _L("Top"), 0.75) GETN_ID(nDataID++)
							GETN_NUM(Bottom, _L("Bottom"), 0.75) GETN_ID(nDataID++)
						GETN_END_BRANCH(Margins)
					GETN_END_BRANCH(Dimensions)
					*/
					/// Hong 07/22/09 QA80-13935 MOVE_PRINT_OPTION_TO_HIGHER_LEVEL
					/*
				#ifdef		SUPPORT_EXPORT_MULTI_PAGES_PDF
					Tree		trFullPrintOptsTree;
					if ( _get_print_opts(trFullPrintOptsTree) )
					{
						GETN_BEGIN_BRANCH(Print, _L("Advance Options")) GETN_CHECKBOX_BRANCH(0) GETN_ID(nDataID++)
						{
							TreeNode		trPrint = GETN_CURRENT_NODE;
							trPrint.Replace(trFullPrintOptsTree, TRUE, TRUE, TRUE);
							_set_treenode_inc_dataid(trPrint, nDataID);
						}
						GETN_END_BRANCH(Print)
					}
				#endif		//SUPPORT_EXPORT_MULTI_PAGES_PDF
					*/
					/// end MOVE_PRINT_OPTION_TO_HIGHER_LEVEL
					/// end WKS_EXPORT_MULTIPAGE_PDF_PAGE_BREAKS
					
					GETN_BEGIN_BRANCH(CoverPage, _L("Cover Page"))	GETN_CHECKBOX_BRANCH(0) GETN_ID(nDataID++)
						GETN_MULTILINE_TEXT(Text, _L("Text"), "") GETN_OPTION_MUTILINE_TEXT_BOX(false, "2-15", true) SET_EDITBOX_RESIZABLE(0) GETN_ID(nDataID++)
						GETN_BEGIN_BRANCH(Font, _L("Font"))
							/// Hong 08/10/09 QA80-13280 IMRPOVE_EXP_MULTI_PDF_FONT_NAME_USE_FONT_LIST_CONTROL
							////GETN_LIST(Name, "Name") ==> Hong, to do, how to can the font name list
							//GETN_STR(Name, _L("Name"), "Times New Roman") GETN_ID(nDataID++)
							GETN_FONT(Name, _L("Name"), 0) GETN_ID(nDataID++)
							/// end IMRPOVE_EXP_MULTI_PDF_FONT_NAME_USE_FONT_LIST_CONTROL
							GETN_COMBO(Size, _L("Size"), 18, "|8|9|10|11|12|14|16|18|20|22|24|26|28|36|48|72") GETN_ID(nDataID++)
							GETN_CHECK(Bold, _L("Bold"), 1) GETN_ID(nDataID++)
							GETN_CHECK(Italic, _L("Italic"), 0) GETN_ID(nDataID++)
							GETN_CHECK(Underline, _L("Underline"), 0) GETN_ID(nDataID++)
						GETN_END_BRANCH(Font)
					GETN_END_BRANCH(CoverPage)
					
					/// Iris 9/29/2009 QA80-14386-P1 CHANGE_LABEL_TO_PAGE_NUMBERING
					//GETN_BEGIN_BRANCH(Pagination, _L("Pagination"))	GETN_CHECKBOX_BRANCH(0) GETN_ID(nDataID++)
					GETN_BEGIN_BRANCH(Pagination, _L("Page Numbering"))	GETN_CHECKBOX_BRANCH(0) GETN_ID(nDataID++)					
					///end CHANGE_LABEL_TO_PAGE_NUMBERING
						GETN_BEGIN_BRANCH(FontP, _L("Font"))
							/// Hong 08/10/09 QA80-13280 IMRPOVE_EXP_MULTI_PDF_FONT_NAME_USE_FONT_LIST_CONTROL
							////GETN_LIST(Name, "Name") ==> to do, how to can the font name list
							//GETN_STR(Name, _L("Name"), "Times New Roman") GETN_ID(nDataID++)
							GETN_FONT(Name, _L("Name"), 0) GETN_ID(nDataID++)
							/// end IMRPOVE_EXP_MULTI_PDF_FONT_NAME_USE_FONT_LIST_CONTROL
							GETN_COMBO(Size, _L("Size"), 18, "|8|9|10|11|12|14|16|18|20|22|24|26|28|36|48|72") GETN_ID(nDataID++)
							GETN_CHECK(Bold, _L("Bold"), 1) GETN_ID(nDataID++)
							GETN_CHECK(Italic, _L("Italic"), 0) GETN_ID(nDataID++)
							GETN_CHECK(Underline, _L("Underline"), 0) GETN_ID(nDataID++)
						GETN_END_BRANCH(FontP)
						GETN_CHECK(Top, _L("Top"), 0) GETN_ID(nDataID++)
						GETN_CHECK(Bottom, _L("Bottom"), 0) GETN_ID(nDataID++)
						GETN_LIST(HorizPos, _L("Horizontal Position"), 3, _L("Left on even, right on odd pages|Left|Right|Center")) GETN_ID(nDataID++)
					GETN_END_BRANCH(Pagination)
				GETN_END_BRANCH(MultiPage)
				/// Hong 07/21/09 QA80-13280-P4 WKS_EXPORT_MULTIPAGE_PDF_PAGE_BREAKS
				/*
				/// Hong 06/17/09 QA80-13280 EXPORT_MULTI_PAGES_PDF_MORE_PRINT_OPTIONS
			#ifdef		SUPPORT_EXPORT_MULTI_PAGES_PDF
				Tree		trFullPrintOptsTree;
				if ( _get_print_opts(trFullPrintOptsTree) )
				{
					GETN_BEGIN_BRANCH(Print, _L("Other Options"))
					{
						TreeNode		trPrint = GETN_CURRENT_NODE;
						trPrint.Replace(trFullPrintOptsTree.FirstNode, TRUE, TRUE, TRUE);
						foreach ( TreeNode trNode in trPrint.Children )
							trNode.DataID = nDataID++;
					}
					GETN_END_BRANCH(Print)
				}
			#endif		//SUPPORT_EXPORT_MULTI_PAGES_PDF
				/// end EXPORT_MULTI_PAGES_PDF_MORE_PRINT_OPTIONS
				*/
				/// end WKS_EXPORT_MULTIPAGE_PDF_PAGE_BREAKS
			}
			/// Hong 06/17/09 QA80-13280 HIDE_OPTION_NO_NEED_FOR_EXPORT_MULTI_PAGES_PDF
		#ifdef		SUPPORT_EXPORT_MULTI_PAGES_PDF
			/// Hong 07/23/09 QA80-13935 HIDE_EXPORT_SETTING_BRANCE_FOR_EXPORT_MULTI_PAGES_PDF
			/*Marko comment that in VC the DPI is not used any more, so hide it in GUI
			else if ( 0 == lstrcmpi(lpcszVarName, "tr") )
			{
				tree_set_attribute_to_all_nodes(tr, STR_SHOW_ATTRIB, "0", true);
				tr.Advanced.Show = 1;
			}
			*/
			/// end HIDE_EXPORT_SETTING_BRANCE_FOR_EXPORT_MULTI_PAGES_PDF
			// Hong, code below fail to work, so move to before_execute
			//else if ( 0 == lstrcmpi(lpcszVarName, "tr1") )
			//	tr.Show = FALSE;
		#endif		//SUPPORT_EXPORT_MULTI_PAGES_PDF
			/// end HIDE_OPTION_NO_NEED_FOR_EXPORT_MULTI_PAGES_PDF
		}
		/// Hong 07/22/09 QA80-13935 MOVE_PRINT_OPTION_TO_HIGHER_LEVEL
	#ifdef		SUPPORT_EXPORT_MULTI_PAGES_PDF
		if ( bMultiPgPDF && 0 == lstrcmpi(lpcszVarName, "tr3") )
		{
			Tree		trFullPrintOptsTree;
			if ( _get_print_opts(trFullPrintOptsTree) )
			{
				tr.Replace(trFullPrintOptsTree, TRUE, TRUE, TRUE);
				/// Hong 11/03/09 QA80-14562 REMOVE_PAGE_SETUP_RELATIVE_OPTIONS_FROM_EXPORT_GUI
				/*
				/// Hong 10/30/09 QA80-14562 EXP_MULTI_PAGE_PDF_SUPPORT_ORIENTATION_OPTION
				TreeNode	trOrientation = tr.InsertNode(tr.FirstNode, "Orientation", ONODETYPE_RADIOS_BY_INDEX);
				trOrientation.SetAttribute(STR_LABEL_ATTRIB, _L("Page Orientation"));
				trOrientation.SetAttribute(STR_COMBO_ATTRIB, _L("Portrait|Landscape"));
				trOrientation.nVal  = 0;
				/// end EXP_MULTI_PAGE_PDF_SUPPORT_ORIENTATION_OPTION
				*/
				/// end REMOVE_PAGE_SETUP_RELATIVE_OPTIONS_FROM_EXPORT_GUI
				TreeNode	trUseOwn = tr.InsertNode(tr.FirstNode, "UseOwn", TRGP_CHECK);
				trUseOwn.nVal = 1;
				trUseOwn.SetAttribute(STR_LABEL_ATTRIB, _L("Use Worksheet's Own Setttings"));
				int			nDataID = GET_USER_DATAID(100); // others reserve for MultiPage
				_set_treenode_inc_dataid(tr, nDataID);
			}
			return 0;
		}
	#endif		//SUPPORT_EXPORT_MULTI_PAGES_PDF
		/// end MOVE_PRINT_OPTION_TO_HIGHER_LEVEL
		
		return nRet;
		/// end SUPPORT_EXPORT_MULTI_PAGES_PDF
		//------ End MOVE_EXPORT_GRAPH_MAKE_TREE_TO_VC
	}
	
	/// Hong 04/13/09 QA80-13280 EXP_SINGLE_WKS_TO_MILTI_PAGES_PDF
	//void 	InvokeBeforeExecute(TreeNode& trGetN, int nGetNDialog, int& nRet, int dwCntrl)
	void 	InvokeBeforeExecute(TreeNode& trGetN, int nGetNDialog, int& nRet, int dwCntrl, bool bMultiPgPDF = false)
	/// end EXP_SINGLE_WKS_TO_MILTI_PAGES_PDF
	{
		///---Sim 06-20-2007 TEST_SPEED
		#ifdef _TEST_SPEED
		//Profiler pro; 
		show_time(NULL); 
		#endif // _TEST_SPEED
		///---END TEST_SPEED
	
		bool bUsedTheme = _is_theme_applied(trGetN); 
		SetGetNOptions(trGetN);
		/// Hong 04/13/09 QA80-13280 EXP_SINGLE_WKS_TO_MILTI_PAGES_PDF
		if ( bMultiPgPDF )
		{
			/// Hong 06/17/09 QA80-13280 HIDE_OPTION_NO_NEED_FOR_EXPORT_MULTI_PAGES_PDF
		#ifdef		SUPPORT_EXPORT_MULTI_PAGES_PDF
			trGetN.tr1.Show = FALSE;
			trGetN.tr.Show = FALSE; /// Hong 07/23/09 QA80-13935 HIDE_EXPORT_SETTING_BRANCE_FOR_EXPORT_MULTI_PAGES_PDF
		#endif		//HIDE_OPTION_NO_NEED_FOR_EXPORT_MULTI_PAGES_PDF
			/// end EXPORT_MULTI_PAGES_PDF_MORE_PRINT_OPTIONS
			StringArray		saExtensions;
			GetImageTypeExtensions(saExtensions);
			int				nIndex = saExtensions.Find("PDF");
			if ( -1 == nIndex )
			{
				warning_msg_box("Not supported", false); // Hong, temp
				nRet = XFEVT_ABORT;
				return;
			}
			trGetN.type.nVal = nIndex;
			
			TreeNode 		trPDF = getPDFOptions(GetImageOptions());
			if ( !trPDF )
			{
				warning_msg_box("Fail to find PDF options", false); // Hong, temp
				nRet = XFEVT_ABORT;
				return;
			}
		}
		/// end EXP_SINGLE_WKS_TO_MILTI_PAGES_PDF
		SetImageType(_gui_get_image_type(trGetN));
		
		if(dwCntrl & LTXF_FROM_MRU_MENU)
		{
			nRet = XFEVT_PROCEED_NO_DLG;
		}
	
		if(nGetNDialog >= 0)
		{
			if ( EXIST_LAYOUT == GetPageType() )
			{
				///---put assumption into couple static function
				//trGetN.export.SetAttribute(STR_COMBO_ATTRIB, STR_COMBO_LAYOUT);
				_remove_embeded_option_if_layout(trGetN.export);
				///---
				trGetN.pages.SetAttribute(STR_ENABLE_EMBED_ATTRIB, 0);				
			}
		}	
		
		if ( nGetNDialog > -1 )
		{
			if ( 0 == nGetNDialog )
			{
				bool bOK = true;
				_gui_check_update_path(trGetN, NULL, &bOK);
				if ( !bOK )
				{
					nRet = XFEVT_ABORT;
					return;
				}
			}
			

			if ( nGetNDialog > 0 )
				/// Hong 10/13/09 QA80-13280-S3 BETTER_PREDEFINE_FILE_NAME_LABEL_FOR_WKS
				//_gui_init_filename_list(trGetN);
				_gui_init_filename_list(trGetN, getPredefinedFileName());
				/// end BETTER_PREDEFINE_FILE_NAME_LABEL_FOR_WKS

			string strErrMsg;
			bool bOK = true;
			AfterChangedPageSelectionOption(trGetN, &strErrMsg, &bOK);
			if ( !strErrMsg.IsEmpty() )
				///---Sim 09-21-2009 FIX_OPEN_EXP_WKS_RUNTIME_ERROR_IF_NO_WKS_ACTIVE
				//warning_msg_box(atoi(strErrMsg), false);
				warning_msg_box(atoi(strErrMsg), false, bOK ? 'W' : 'E');
				///---END FIX_OPEN_EXP_WKS_RUNTIME_ERROR_IF_NO_WKS_ACTIVE
			if ( !bOK)
			{
				nRet = XFEVT_ABORT;
				return;
			}
			
			/// Hong 07/21/09 QA80-13280-P4 WKS_EXPORT_MULTIPAGE_PDF_PAGE_BREAKS
			if ( bMultiPgPDF )
				checkUpdatePrintOpts(trGetN);
			/// end WKS_EXPORT_MULTIPAGE_PDF_PAGE_BREAKS
			
			//guiInitPageSettings(trGetN);  //update page setting according to input Page	
			///---Sim 12-24-2008 QA80-12853 FIX_SHOW_RASTER_IMAGE_PIXEL_SIZE_WHEN_RATIO_UNIT
			//guiInitPageSettings(trGetN.pages.strVal);  //update page setting according to input Page	
			///Kyle 07/07/2010 ORG-338-P1 AUTO_WIDTH_HEIGHT_FOR_EXPORT_GRAPH, update size control after updating margin control
			//guiInitPageSettings(trGetN, trGetN.pages.strVal);  //update page setting according to input Page	
			///End AUTO_WIDTH_HEIGHT_FOR_EXPORT_GRAPH
			///---END QA80-12853 FIX_SHOW_RASTER_IMAGE_PIXEL_SIZE_WHEN_RATIO_UNIT

			///Kyle 01/28/2010 QA80-15041 WANT_ENABLE_GRAPH_CURRENT_SPEED_MODE_FOR_EXPORT
			TreeNode trExportSetting = GetPageOptions();
			if( trExportSetting.SpeedMode )
			{
				trExportSetting.SpeedMode.Show = EXIST_PLOT==GetPageType();
			}
			///End WANT_ENABLE_GRAPH_CURRENT_SPEED_MODE_FOR_EXPORT
			
			if ( !bUsedTheme )
			{
				if ( trGetN.sysopts.nVal )
				{
					_init_page_settings_def(trGetN);
					///------ Folger 09/14/09 QA80-14314 EXPORT_GRAPH_SUPPORT_READ_DEFAULT_IMAGE_TYPE_FROM_TOOLS_OPTION
					if ( !bMultiPgPDF )
						_check_init_default_image_type(trGetN);
					///------ End EXPORT_GRAPH_SUPPORT_READ_DEFAULT_IMAGE_TYPE_FROM_TOOLS_OPTION
				}
			}
			 	
			if ( EXIST_WKS == GetPageType() )
			{
				_fix_margin_for_worksheet(trGetN); // export worksheet only support border type
			}
			 	
			if ( 0 == nGetNDialog )
			{
				if ( !_check_no_duplicate_names(trGetN) )
				{
					warning_msg_box(CER_DUPLICATE_FILE_NAME, false, 'W');
				}
			}
				
			///Kyle 07/07/2010 ORG-338-P1 AUTO_WIDTH_HEIGHT_FOR_EXPORT_GRAPH, update size control after updating margin control
			//TreeNode 	trRescaling = tree_get_node_by_id(trGetN, PAGE_RESCALING, true);
			//string		strNodeName = 0 == trRescaling.nVal? "Width" : "Height";
			//guiUpdateSizeControls(trGetN, strNodeName);
			guiInitPageSettings(trGetN, trGetN.pages.strVal);
			///End AUTO_WIDTH_HEIGHT_FOR_EXPORT_GRAPH
		}
		
		///---Sim 06-20-2007 TEST_SPEED
		#ifdef _TEST_SPEED
		show_time("after before execute");
		#endif // _TEST_SPEED
		///---END TEST_SPEED	
		
	}
	
	void 	InvokeOnInitGrid(TreeNode& trGetN, bool& bUpdateGraph, bool& bOKEnable, string& strErrMsg)
	{
		#ifdef _TEST_SPEED
		//Profiler pro; 
		show_time(NULL); 
		#endif // _TEST_SPEED
	
		SetGetNOptions(trGetN);
		
		//Init Type Control
		StringArray 	saImageTypeDescriptions;
		GetImageTypeDescriptions(saImageTypeDescriptions);
		_gui_construct_type_list(trGetN, saImageTypeDescriptions);
		
		_gui_update_path_attributes(trGetN);
		
		
		//int	 	nPageType = getSourcePageType(trGetN);
		int	 	nPageType = getSourcePageType(trGetN.pages.strVal);
		trGetN.pages.SetAttribute(STR_BROWSE_PAGE_TYPE_ATTRIB, nPageType); 
		if (nPageType == EXIST_LAYOUT)
			trGetN.pages.SetAttribute(STR_ENABLE_EMBED_ATTRIB, 0);
		trGetN.pages.SetAttribute(STR_PAGE_NAME_INC_LONG_NAME_ATTRIB, 1); 
		
		updateType(trGetN);
		
		updateFilenameAttribute(trGetN); ///---Sim 12-23-2008 QA80-12836 SUPPORT_FILE_BROWSER_BUTTON
		
		/// Hong 12/10/07 v8.0765 FIX_EXPWKS_FAIL_WORK_WITH_AREA
		if ( trGetN.theme )
		{
		/// end FIX_EXPWKS_FAIL_WORK_WITH_AREA
			trGetN.theme.Show = EXIST_PLOT == nPageType? true : false;
			if(trGetN.theme.Show)
				_init_theme_list(trGetN.theme);
		}
		
		CheckError(trGetN, strErrMsg, bOKEnable);
		
		///---Sim 10-10-2009 QA81-14406-P1 TRUN_OFF_TIFF_PREVIEW_IN_EPS_EXPORT_BY_DEFAULT
		tree_set_attribute_to_all_nodes(trGetN.tr, STR_ATTRIB_FORCE_NODE_EVENT_ON, "1");
		tree_set_attribute_to_all_nodes(trGetN.tr1, STR_ATTRIB_FORCE_NODE_EVENT_ON, "1");
		tree_set_attribute_to_all_nodes(trGetN.tr2, STR_ATTRIB_FORCE_NODE_EVENT_ON, "1");
		trGetN.SetAttribute(STR_ATTRIB_FORCE_CALL_NODE_EVENTS, 1);
		///---END QA81-14406-P1 TRUN_OFF_TIFF_PREVIEW_IN_EPS_EXPORT_BY_DEFAULT
		
		///---Sim 07-18-2007 EXTEND_UPDATE_GRAPH_CONTROL_VALUE
		if ( bOKEnable )
			bUpdateGraph = true;
		///---END EXTEND_UPDATE_GRAPH_CONTROL_VALUE
		
		///---Sim 06-20-2007 TEST_SPEED
		#ifdef _TEST_SPEED
		show_time("after init grid");
		#endif // _TEST_SPEED
		///---END TEST_SPEED
	
	}
	
	void 	InvokeOnInitGraph(TreeNode& trGetN, PageBase& pgTemp, PictureControl& pict, string& strErrMsg, bool& bOKEnable)
	{
		///---Sim 06-20-2007 TEST_SPEED
		#ifdef _TEST_SPEED
		//Profiler pro; 
		show_time(NULL); 
		#endif // _TEST_SPEED
		///---END TEST_SPEED
	
		//---- CPY 10/11/07 QA70-10520 POOR_USE_OF_STATIC_LEAD_TO_PERSISTENT_OK_NOT_ENABLED_AFTER_NEW_OPJ
		// should replace all statics with a single structure and assume all default should be 0 or empty so it is simple to reset it here
		// but I have to init them one by one for now
		//_init_all_statics(); /// Hong 11/01/07 v8.0738 CLEAN_ERROR_MSG_MACHNISM
		//----
		
		SetGetNOptions(trGetN);
	
		if( !checkSourcePage(trGetN, strErrMsg, bOKEnable) )
		{
			//s_bValidSourcePage = false;
			m_bValidSourcePage = false; /// Hong 11/01/07 v8.0738 CLEAN_ERROR_MSG_MACHNISM
			return;
		}	
			
		GraphPage gp(pgTemp);
		updateNonePicturePreview(gp, pict);
		
		///---Sim 06-20-2007 TEST_SPEED
		#ifdef _TEST_SPEED
		show_time("after init graph");
		#endif // _TEST_SPEED
		///---END TEST_SPEED		
	}
	
	void 	InvokeOnUpdateGraph(TreeNode& trGetN,  PageBase& pgTemp, Datasheet& wksTemp, PictureControl& pict)
	{
		SetGetNOptions(trGetN);
		
		/// Hong 11/01//07 v8.0738 CENTRALIZE_CODE_OF_GET_PREVIEW_PAGE
		/*
		/// Iris 08/30/2007 QA70-10302 REMOVE_GRAPH_TAB_FOR_WKS_EXPORT
		GraphPage gp(pgTemp);
		bool	bTempCreated = false;
		if(!gp)
		{
			bTempCreated = true;
			gp.Create(NULL, CREATE_SET_MISSING_IN_MANAGER);
		}
		///end REMOVE_GRAPH_TAB_FOR_WKS_EXPORT
			
		Page 	pg;
		int		nLayerIndex = -1;
		if(EXIST_WKS == GetPageType())
		{
			getSourcePage(trGetN.pages.strVal, pg, &nLayerIndex);
		}
		else
		{
			//pageClone(trGetN, gp); //get source graph and make clone to pgTemp
			pageClone(trGetN.pages.strVal, gp); //get source graph and make clone to pgTemp
			_gui_apply_theme(trGetN.theme.strVal, gp);
			pg = gp;
		}		
		*/
		Page 	pg(pgTemp);
		int		nLayerIndex = -1;
		bool	bTempCreated = false;
		getPreviewPage(trGetN, pg, bTempCreated, &nLayerIndex);
		/// end CENTRALIZE_CODE_OF_GET_PREVIEW_PAGE
		
		
		string strType, strExt;
		getImageFileTypeDescripAndExt(strType, strExt);
		
		string strErrMsg;
		updatePicturePreview(pict, pg, nLayerIndex, strExt, strErrMsg, false, trGetN.keepsize.nVal, true);

		if ( !strErrMsg.IsEmpty() )
		{
			/// Hong 11/01/07 v8.0738 CENTRALIZE_CODE_OF_GET_PREVIEW_PAGE
			//updateNonePicturePreview(gp, pict, atoi(strErrMsg));
			GraphPage gp(pg);
			updateNonePicturePreview(gp, pict, atoi(strErrMsg));
			/// end CENTRALIZE_CODE_OF_GET_PREVIEW_PAGE
		}
			
		if(bTempCreated)
			//gp.Destroy();
			pg.Destroy(); /// Hong 11/01/07 v8.0738 CENTRALIZE_CODE_OF_GET_PREVIEW_PAGE
		
	}
	
	/// Hong 07/21/09 QA80-13280-P4 WKS_EXPORT_MULTIPAGE_PDF_PAGE_BREAKS
	//void 	InvokeOnChange(TreeNode& trGetN, TreeNode& trNode, bool& bUpdateGraph, bool& bOKEnable, string& strErrMsg)	
	void 	InvokeOnChange(TreeNode& trGetN, TreeNode& trNode, bool& bUpdateGraph, bool& bOKEnable, string& strErrMsg, bool bMultiPgPDF = false)
	/// end WKS_EXPORT_MULTIPAGE_PDF_PAGE_BREAKS
	{
		SetGetNOptions(trGetN);
		
		bool	bThemeChanged = false;
		string	strNodeName;
		if(trNode)
			strNodeName = trNode.tagName;
		else
			bThemeChanged = true;
		
		strErrMsg = CER_NO_ERROR;	
				
		/// Iris 12/11/2006 v8.0523 EXPORT_PAGE_SUPPORT_MUL_PAGES
		if(bThemeChanged)
		{
			_gui_convert_standard_str_to_page_name(trGetN);
			//------ Folger 12/11/07 SHOULD_INIT_FILENAME_LIST_AND_THEME_LIST_WHEN_CHANGE_THEME
			/// Hong 07/21/09 QA80-13280-P4 WKS_EXPORT_MULTIPAGE_PDF_PAGE_BREAKS
			//_gui_init_filename_list(trGetN);
			_gui_init_filename_list(trGetN, getPredefinedFileName());
			/// end WKS_EXPORT_MULTIPAGE_PDF_PAGE_BREAKS
			if (trGetN.theme) /// Hong 12/25/07 b8.0775 FIX_EXPWKS_FAIL_WHEN_SWITCH_THEME
				_init_theme_list(trGetN.theme);
			//------

			///Kyle 08/24/2010 ORG-338-P3 INIT_PAGE_DEFAULT_SETTING_ON_AFTER_LOAD_SYSTEM_DEFAULT
			if( !_is_theme_applied(trGetN) )
			{
				_init_page_settings_def(trGetN);

				if( !bMultiPgPDF )
					_check_init_default_image_type(trGetN);

				if( EXIST_WKS == GetPageType() )
					_fix_margin_for_worksheet(trGetN); // export worksheet only support border type
			}
			///End INIT_PAGE_DEFAULT_SETTING_ON_AFTER_LOAD_SYSTEM_DEFAULT
		}
		

		///---Sim 12-23-2008 QA80-12836 SUPPORT_FILE_BROWSER_BUTTON
		//if ( !lstrcmpi(strNodeName, "path") || bThemeChanged )
		if ( !lstrcmpi(strNodeName, "filename") )
		{
			updatePathFromFileBrowserAttribute(trGetN);
		}
		
		if ( !lstrcmpi(strNodeName, "filename") || !lstrcmpi(strNodeName, "path") || bThemeChanged )
		///---END QA80-12836 SUPPORT_FILE_BROWSER_BUTTON
		{	
			string strErr;
			_gui_check_update_path(trGetN, &strErr, &bOKEnable);
			/// Hong 11/01/07 v8.0738 CLEAN_ERROR_MSG_MACHNISM
			//s_bValidPath = strErr.IsEmpty();
			//s_strErrPath = strErr;
			m_bValidPath = strErr.IsEmpty();
			m_strErrPath = strErr;
			/// end CLEAN_ERROR_MSG_MACHNISM
		}

		if ( !lstrcmpi(strNodeName, "filename") || bThemeChanged )
		{	
			string strErr;
			_gui_check_filename(trGetN, strErr, bOKEnable);
			//s_bValidFileName = strErr.IsEmpty();
			m_bValidFileName = strErr.IsEmpty(); /// Hong 11/01/07 v8.0738 CLEAN_ERROR_MSG_MACHNISM
		}

		if(!lstrcmpi(strNodeName, "export") || !lstrcmpi(strNodeName, "pages") || bThemeChanged)
		{
			string strErr;
			AfterChangedPageSelectionOption(trGetN, &strErr);
			//s_bNoHierarchySheet = strErr.IsEmpty();	
			m_bNoHierarchySheet = strErr.IsEmpty(); /// Hong 11/01/07 v8.0738 CLEAN_ERROR_MSG_MACHNISM

			strErr.Empty();
			if( checkSourcePage(trGetN, strErr, bOKEnable) )
			{
				//guiInitPageSettings(trGetN);  //update page setting according to input Page
				///---Sim 12-24-2008 QA80-12853 FIX_SHOW_RASTER_IMAGE_PIXEL_SIZE_WHEN_RATIO_UNIT
				//guiInitPageSettings(trGetN.pages.strVal);
				guiInitPageSettings(trGetN, trGetN.pages.strVal);
				///---END QA80-12853 FIX_SHOW_RASTER_IMAGE_PIXEL_SIZE_WHEN_RATIO_UNIT
				/// Hong 07/21/09 QA80-13280-P4 WKS_EXPORT_MULTIPAGE_PDF_PAGE_BREAKS
				if ( bMultiPgPDF )
					checkUpdatePrintOpts(trGetN);
				/// end WKS_EXPORT_MULTIPAGE_PDF_PAGE_BREAKS
			}

			bUpdateGraph = true;
			//s_bValidSourcePage = strErr.IsEmpty();
			m_bValidSourcePage = strErr.IsEmpty(); /// Hong 11/01/07 v8.0738 CLEAN_ERROR_MSG_MACHNISM
	
			// width will init with source page changed
			/// Hong 11/01/07 v8.0738 CLEAN_ERROR_MSG_MACHNISM
			//s_bValidWidth = true;
			//s_strErrWidth = "";
			m_bValidWidth = true;
			m_strErrWidth = "";
			/// end CLEAN_ERROR_MSG_MACHNISM
		}
		
		///---Sim 08-17-2007 CHECK_DUPLICATE_FILE_NAMES
		// warning message
		if(!lstrcmpi(strNodeName, "export") || !lstrcmpi(strNodeName, "pages") 
			|| !lstrcmpi(strNodeName, "filename") || !lstrcmpi(strNodeName, "overwrite") || bThemeChanged)
		{
			/// Hong 11/01/07 v8.0738 CLEAN_ERROR_MSG_MACHNISM
			//if ( s_bValidFileName && s_bValidSourcePage )
			//{	// must make sure trGetN.filename and trGetN.pages are OK to used
			//	s_bNoDuplicateFileName = _check_no_duplicate_names(trGetN);
			//}
			if ( m_bValidFileName && m_bValidSourcePage )
			{	// must make sure trGetN.filename and trGetN.pages are OK to used
				m_bNoDuplicateFileName = _check_no_duplicate_names(trGetN);
			}
			/// end CLEAN_ERROR_MSG_MACHNISM
		}
		///---END CHECK_DUPLICATE_FILE_NAMES
		
		//event on Page Settings branch
		guiUpdateSizeControls(trGetN, strNodeName);	

		//------ Folger 03/12/08 APPLY_NEW_DEFAULT_THEME_MECHANISM_FOR_GRAPH_EXPORT
		//if ( bThemeChanged && (THEME_FACTORY_DEFAULT == xf_is_theme_applied(trGetN)) && trGetN.sysopts.nVal ) // factory default theme and load system page setting
		///---Sim 09-05-2008 CLEAN_DEFAULT_THEME
		//if ( bThemeChanged && (THEME_NONE == xf_is_theme_applied(trGetN)) && trGetN.sysopts.nVal )
		if ( bThemeChanged && !_is_theme_applied(trGetN) && trGetN.sysopts.nVal )
		///---END CLEAN_DEFAULT_THEME
		//------
		{
			_init_page_settings_def(trGetN);
			///------ Folger 09/14/09 QA80-14314 EXPORT_GRAPH_SUPPORT_READ_DEFAULT_IMAGE_TYPE_FROM_TOOLS_OPTION
			if ( !bMultiPgPDF )
				_check_init_default_image_type(trGetN);
			///------ End EXPORT_GRAPH_SUPPORT_READ_DEFAULT_IMAGE_TYPE_FROM_TOOLS_OPTION
		}
	 	
		//---- Iris 11/06/06 MOVE_RATIO_TO_INSIDE_WIDTH
		TreeNode	trPageSettings = trGetN.tr1;
		bool		bUnitChanged = !lstrcmpi(strNodeName, "Unit");
		bool		bSizeChanged = ( !lstrcmpi(strNodeName, "Width") || !lstrcmpi(strNodeName, "Height") );
		if ( bSizeChanged || !lstrcmpi(strNodeName, "theme") || !lstrcmpi(strNodeName, "export") || bThemeChanged )
		{
			string strErr;
			_gui_check_size_node(trPageSettings, strErr, bOKEnable);
			/// Hong 11/01/07 v8.0738 CLEAN_ERROR_MSG_MACHNISM
			//s_bValidWidth = strErr.IsEmpty();
			//s_strErrWidth = strErr;
			m_bValidWidth = strErr.IsEmpty();
			m_strErrWidth = strErr;
			/// end CLEAN_ERROR_MSG_MACHNISM
			
			bUpdateGraph = true;		
		}
		

		if( !lstrcmpi(strNodeName, "Theme") || bThemeChanged)
		{	
			bUpdateGraph = true;
		}
		
		if( !lstrcmpi(strNodeName, "Margin") || bThemeChanged)
		{
			///---Sim 12-26-2007 QA80-10364-P10 FIX_THEME_CHANGE_BROKEN_EXPORT
			if ( EXIST_WKS == GetPageType() )
			{
				_fix_margin_for_worksheet(trGetN); // export worksheet only support border type
			}
			///---END QA80-10364-P10 FIX_THEME_CHANGE_BROKEN_EXPORT
			trGetN.tr.BorderWid.Enable = 0 == trGetN.tr.Margin.nVal? true : false;
			bUpdateGraph = true;
		}
		
		if(!lstrcmpi(strNodeName, "DotsperInch") || !lstrcmpi(strNodeName, "BorderWid") || !lstrcmpi(strNodeName, "type") ||
			!lstrcmpi(strNodeName, "BitsPerPixel") || !lstrcmpi(strNodeName, "Compression") ||
			!lstrcmpi(strNodeName, "ColorSpace") ||//the node in TIF
			!lstrcmpi(strNodeName, "ColorTranslation") ||//)//the node in PDF
			!lstrcmpi(strNodeName, "OtherSetting") )		
		{
			bUpdateGraph = true;
		}

		if ( !lstrcmpi(strNodeName, "type") || bThemeChanged )
		{
			updateType(trGetN);
		}
		
		///---Sim 12-23-2008 QA80-12836 SUPPORT_FILE_BROWSER_BUTTON
		if ( !lstrcmpi(strNodeName, "type") || !lstrcmpi(strNodeName, "path") || bThemeChanged )
		{
			updateFilenameAttribute(trGetN);
		}
		///---END QA80-12836 SUPPORT_FILE_BROWSER_BUTTON
		
		///---Sim 12-24-2008 QA80-12853 FIX_NOT_UPDATE_RASTER_IMAGE_PIXEL_SIZE_WHEN_CHANGE_HEIGHT
		//if(	!lstrcmpi(strNodeName, "DotsperInch") || !lstrcmpi(strNodeName, "Width") || !lstrcmpi(strNodeName, "type") || bThemeChanged )
		///---Sim 01-04-2008 QA80-12853-P4 FIX_NOT_UPDATE_RASTER_IMAGE_PIXEL_SIZE_WHEN_CHANGE_MARGIN_OR_BORDER_WIDTH
		//if(	!lstrcmpi(strNodeName, "DotsperInch") || !lstrcmpi(strNodeName, "Width") || !lstrcmpi(strNodeName, "Height") || !lstrcmpi(strNodeName, "type") || bThemeChanged )
		if(	!lstrcmpi(strNodeName, "DotsperInch") || !lstrcmpi(strNodeName, "Width") || !lstrcmpi(strNodeName, "Height") || !lstrcmpi(strNodeName, "type")
			///Kyle 08/23/2010 ORG-338-S1 SHOW_PAGE_ORIGINAL_SIZE_AS_HINT
			//|| !lstrcmpi(strNodeName, "Margin") || !lstrcmpi(strNodeName, "BorderWid") || bThemeChanged )
			///Kyle 08/24/2010 ORG-338-P4 UPDATE_AUTO_WIDTH_AND_HEIGHT_ON_RESCALING_CHANGE
			//|| !lstrcmpi(strNodeName, "Margin") || !lstrcmpi(strNodeName, "BorderWid") || !lstrcmpi(strNodeName, "Area") || bThemeChanged )
			|| !lstrcmpi(strNodeName, "Margin") || !lstrcmpi(strNodeName, "BorderWid") || !lstrcmpi(strNodeName, "Area") || !lstrcmpi(strNodeName, "Rescaling") ||
			bThemeChanged )
			///End UPDATE_AUTO_WIDTH_AND_HEIGHT_ON_RESCALING_CHANGE
			///End SHOW_PAGE_ORIGINAL_SIZE_AS_HINT
		///---END QA80-12853 FIX_NOT_UPDATE_RASTER_IMAGE_PIXEL_SIZE_WHEN_CHANGE_MARGIN_OR_BORDER_WIDTH
		{
			///---Sim 12-24-2008 QA80-12853 FIX_SHOW_RASTER_IMAGE_PIXEL_SIZE_WHEN_RATIO_UNIT
			//updatePixelSizeControl(false);
			updatePixelSizeControl(trGetN, false);
			///---END QA80-12853 FIX_SHOW_RASTER_IMAGE_PIXEL_SIZE_WHEN_RATIO_UNIT
		}
		
		/// Hong 09/11/09 QA80-13280-S2 MAKE_PRINT_OPTS_READONLY_IF_NOT_USED
		if ( bMultiPgPDF )
		{
			TreeNode		trNode = trGetN.tr3.UseOwn;
			if ( trNode )
			{
				int				nEnableStatis = trNode.nVal ? ENABLE_READ_ONLY : ENABLE;
				while ( trNode.NextNode )
				{
					trNode = trNode.NextNode;
					tree_set_attribute_to_all_nodes(trNode, STR_ENABLE_ATTRIB, (string)nEnableStatis);
				}
			}
		}
		/// end MAKE_PRINT_OPTS_READONLY_IF_NOT_USED

		if ( _is_image_relative_setting(trNode) )
			bUpdateGraph = true;
		
		/// Hong 11/01/07 v8.0738 CLEAN_ERROR_MSG_MACHNISM
		//OK_SURE(bOKEnable);
		//_get_error_message(strErrMsg);
		bOKEnable = IsOKSure(); 
		strErrMsg = GetErrorMessage();
		/// end CLEAN_ERROR_MSG_MACHNISM
	}
	
	/// Hong 04/17/09 QA80-13280 SUPPORT_EXPORT_MULTI_PAGES_PDF
	//void 	InvokeExpGraph(int nType, int nExport, LPCSTR lpcszPages, LPCSTR lpcszFilename, LPCSTR lpcszPath, int nOverwriteOpt, 
	//				bool bSysOpts, bool bKeepSize, LPCSTR lpcszTheme = NULL)
	void 	InvokeExpGraph(int nType, int nExport, LPCSTR lpcszPages, LPCSTR lpcszFilename, LPCSTR lpcszPath, int nOverwriteOpt, 
					bool bSysOpts, bool bKeepSize, LPCSTR lpcszTheme = NULL, bool bMultiPgPDF = false)
	/// end SUPPORT_EXPORT_MULTI_PAGES_PDF
	{
		TreeNode tr, tr1, tr2;
		tr = GetPageOptions();
		tr1 = GetPageSize();
		tr2 = GetImageOptions();				
		
		string strInputPages(lpcszPages);
		if(strInputPages.IsEmpty())
		{
			XF_THROW(CER_INVALID_GRAPH);
		}
		
		if( !export_check_path_show_warnning(strInputPages) )
		{
			XF_THROW(CER_FILE_ALREADY_EXISTS);
		}	
		
		/// Iris 12/11/2006 SUPPORT_MUL_PAGES
		vector<string>	vsPages;
		string		strPages = get_page_short_name_from_page_list(strInputPages, STR_PAGE_LIST_SEPARATOR, -1);
		int 		numPages = strPages.GetTokens(vsPages, STR_PAGE_LIST_SEPARATOR);
		if(0 == numPages)
			XF_THROW(CER_INVALID_GRAPH);	
		///END SUPPORT_MUL_PAGES
		

		string 	strType, strExt;
		getImageFileTypeDescripAndExt(strType, strExt);
		
		vector<string> vsFilename;
		for(int ii=0; ii<vsPages.GetSize(); ii++)
		{
			string strMessage;		
			//create temp page for export and apply graph theme 
			bool	bExportWks = false;
			int		nLayerIndex = -1;
			Page	pg(vsPages[ii]);
			if(!pg)
			{
				Worksheet wks;
				wks.Attach(vsPages[ii]);
				if(wks)
				{
					nLayerIndex = wks.GetIndex();
					pg = wks.GetPage();
					bExportWks = true;
				}
			}
			
			if(!pg)
			{
				strMessage.Format(_L("Page %s is invalid."), vsPages[ii]);
				okoc_out_msg(strMessage);
				continue;
			}

			string strFullPath = _check_get_full_path(lpcszFilename, strExt, lpcszPath, vsPages[ii], ii, nOverwriteOpt);

			///---Sim 09-29-2009 QA80-14386-P3 AUTO_RENAME_JUST_NEED_ASK_ONE_TIMES
			if ( c_overwrite_cancel == nOverwriteOpt )
			{
				break; // user cancel
			}
			///---END QA80-14386-P3 AUTO_RENAME_JUST_NEED_ASK_ONE_TIMES
			
			if ( strFullPath.IsEmpty() )
			{ // skip export this file
				continue;
			}
	
			BOOL		bDestroyTemp = FALSE;
			Page pgTemp;
			if(bExportWks)
			{
				pgTemp = pg;
			}
			else
			{
				//--------- CPY 5/6/08 QA70-11514 LAYOUT_PAGE_EXPORT_NOT_USING_WRONG_TEMP_PAGE_TYPE
				/*
				GraphPageBase gp(vsPages[ii]);
				GraphPage gpTemp;
				gpTemp.Create("origin", CREATE_SET_MISSING_IN_MANAGER);	
				//gp.CreateCopy(gpTemp);
				cleanPageClone(gp, gpTemp); /// Hong 11/05/07 v8.0740 FIX_EXP_GRAPH_FAIL_WITH_AXIS_SCROLLBAR
				*/
				
				/// YuI 05/20/08 QA70-11570 PAGE_EXPORT_FAILS_IF_LONG_NAME_PRESENT
				// no code change, just comment here - vsPages gets constructed by first calling
				// get_page_short_name_from_page_list, so vsPages[ii] is good short name
				/// end PAGE_EXPORT_FAILS_IF_LONG_NAME_PRESENT
				
				GraphPage gpTemp = clone_graph(vsPages[ii]);
				//----------
				///Kyle 07/30/2010 ORG-674-P1 EXPORT_LAYOUT_SHOULD_NOT_APPLY_THE_THEME_FOR_GRAPH
				//_gui_apply_theme(lpcszTheme, gpTemp);
				if( EXIST_PLOT == GetPageType() )
					_gui_apply_theme(lpcszTheme, gpTemp);
				///End EXPORT_LAYOUT_SHOULD_NOT_APPLY_THE_THEME_FOR_GRAPH
				pgTemp = gpTemp;
				bDestroyTemp = TRUE;
			}
			
			string strErrMsg;
			/// Hong 04/17/09 QA80-13280 SUPPORT_EXPORT_MULTI_PAGES_PDF
			//int		nErr = exportPage(pgTemp, nLayerIndex, strFullPath, strExt, strErrMsg, NULL, false, false, bKeepSize, true);
			int		nErr = exportPage(pgTemp, nLayerIndex, strFullPath, strExt, strErrMsg, NULL, false, false, bKeepSize, true, bMultiPgPDF);
			/// end SUPPORT_EXPORT_MULTI_PAGES_PDF

			///Sophy 10/18/2010 ORG-1276 PROPER_SHOW_RESULT_MESSAGE_ON_PAGE_EXPORT
			//if (strFullPath.IsFile())
				//ocu_load_msg_str(XF_EXPORT_SUCCESS, &strMessage, vsPages[ii], NULL, strFullPath);
			//else
				//ocu_load_msg_str(XF_EXPORT_FAILED, &strMessage, vsPages[ii], NULL, strFullPath);
//
			ocu_load_msg_str((nErr == CER_NO_ERROR && strFullPath.IsFile()) ? XF_EXPORT_SUCCESS : XF_EXPORT_FAILED, &strMessage, vsPages[ii], NULL, strFullPath);
			///end PROPER_SHOW_RESULT_MESSAGE_ON_PAGE_EXPORT
			okoc_out_msg(strMessage, 'I');
			
			if( nErr )
			{
				///---Sim 05-30-2008 FIX_ERRMSG_EXP_IMAGE
				/*
				if(strErrMsg.IsEmpty())
					XF_THROW(nErr);
				XF_THROW_EX(nErr, strErrMsg);
				*/
				XF_THROW_EX(XFERR_LEADTOOLS_FUNCTION_UNKNOWN_ERR, nErr);
				///---END FIX_ERRMSG_EXP_IMAGE
			}
			/// ML 10/11/2007 QA70-10519 DESTROY_AFTER_EXPORT
			if ( bDestroyTemp  && pgTemp)
				pgTemp.Destroy();
			/// end DESTROY_AFTER_EXPORT
		}
		
		string strPath = cvt_predefined_path_to_real_path(lpcszPath);
		if(strPath.IsPath())
			update_recent_path_list(lpcszPath);
	}
	
	TreeNode	GetImageOptions()
	{
		if ( !m_pExpPage )
		{
			ASSERT(false);
			return NULL;
		}
		return m_pExpPage->GetImageOptions();
	}
	TreeNode	GetPageOptions() { return m_trPageOptions; }
	TreeNode	GetPageSize() { return m_trPageSize; }
	
	void	SetImageOptions(const TreeNode& trImageOptions)
	{
		if ( !m_pExpPage )
		{
			ASSERT(false);
			return;
		}
		m_pExpPage->SetImageOptions(trImageOptions);
	}
	
	void	SetPageOptions(const TreeNode& trPageOptions)
	{
		m_trPageOptions = trPageOptions;
	}

	void	SetPageSize(const TreeNode& trPageSize)
	{
		m_trPageSize = trPageSize;
	}
	
	/// Hong 07/22/09 QA80-13935 MOVE_PRINT_OPTION_TO_HIGHER_LEVEL
	void	SetPrintOptions(const TreeNode& trPrintOpts)
	{
		m_trPrintOpts = trPrintOpts;
	}
	TreeNode	GetPrintOptions() { return m_trPrintOpts; }
	/// end MOVE_PRINT_OPTION_TO_HIGHER_LEVEL

	void	ConstructPageSettingsGUI(TreeNode& tr)
	{
		GETN_USE(tr)
		///Jasmine 04/21/07 ADD_USE_SYSTEM_SETTING_OPTION
		//GETN_BEGIN_BRANCH(OtherSetting, _L("Other Settings")) GETN_COMBO_BRANCH(0, _L("System Options|User-Defined")) GETN_OPTION_EVENT_EX(_branch_combo_event)
				
		//GETN_LIST(Margin, "Margin Control", 1, "Border|Tight|Page")	GETN_ID(PAGE_MARGIN_CONTROL)	//GETN_OPTION_EVENT(_gui_margin_settings_event)	/// Max 3/15/07 GREG_REQUIRE_PAGE_AS_DEFAULT_MARGIN_CONTROL
		//------ Folger 02/03/08 QA80-11008 CHECK_TREENODE_AUTO_ATTRRIBUTE_BEFORE_UPDATE_VALUE
		//GETN_LIST(Margin, _L("Margin Control"), 2, _L("Border|Tight|Page|Tight in Page"))	GETN_ID(PAGE_MARGIN_CONTROL)	//GETN_OPTION_EVENT(_gui_margin_settings_event)
		//GETN_COMBO(BorderWid, _L("Clip Border Width"), 5, "|0|5|10|15|20")	GETN_ID(PAGE_BRODER_WIDTH) GETN_READ_ONLY
		GETN_LIST(Margin, _L("Margin Control"), -1, _L("Border|Tight|Page|Tight in Page"))	GETN_ID(PAGE_MARGIN_CONTROL)
		GETN_COMBO(BorderWid, _L("Clip Border Width"), -1, "|0|5|10|15|20")	GETN_ID(PAGE_BRODER_WIDTH) GETN_READ_ONLY
		//------	
		/// Iris 10/09/06 v8.0493 CLEANUP_SET_SIZE_FOR_VECTOR_TYPE
		GETN_BEGIN_BRANCH( Advanced, _L("Advanced") )  //GETN_OPTION_EVENT(_gui_advanced_branch_event)
			GETN_RADIO_INDEX(Resolution, 0, _L("Set Resolution|Keep Size") ) GETN_OPTION_DISPLAY_FORMAT(DISPLAY_EDITOR_LEFT) GETN_ID(PAGE_SIZE) GETN_OPTION_EVENT_EX(_gui_advanced_event)
			GETN_COMBO(DPI, _L("Resolution"), 300, "|100|300|600")	GETN_ID(PAGE_RESOLUTION)		
		GETN_END_BRANCH( Advanced )	
		///end CLEANUP_SET_SIZE_FOR_VECTOR_TYPE
		//GETN_END_BRANCH(OtherSetting)
		///End ADD_USE_SYSTEM_SETTING_OPTION
		
		if ( EXIST_WKS == GetPageType() )
		{
			GETN_LIST(Area, _L("Export Area"), AREA_VISIBLE, _L("Visible|Whole|Selection"))	GETN_ID(PAGE_EXPORT_AREA)
		}	
	}
	
protected:
	bool 	CheckError(TreeNode& trGetN, string &strErrMsg, bool &bOKEnable)
	{
		_gui_check_update_path(trGetN, &strErrMsg, &bOKEnable);	

		_gui_check_filename(trGetN, strErrMsg, bOKEnable);
		
		if ( bOKEnable )
		{
			if ( !_check_no_duplicate_names(trGetN) )
				strErrMsg = CER_DUPLICATE_FILE_NAME;
		}
		
		return true;
	}

	int 	GetDPI(LPCSTR lpcszExt = NULL)
	{
		TreeNode trPageOptions = GetPageOptions();
		TreeNode trImageOptions = GetImageOptions();
		string strExt = GetImageTypeExtension();
		if ( lpcszExt )
			strExt = lpcszExt;
		
		if( is_image_file_type_ext(strExt, IFT_VECTOR) )
		{
			if(trPageOptions.Advanced.Show)
				return trPageOptions.Advanced.DPI.nVal;
		}
		else if( is_image_file_type_ext(strExt, IFT_RASTER) )
		{	
			TreeNode	trImageDPI;	
			TreeNode 	trN = trImageOptions.GetNode(strExt, false);
			if(trN)
			{
				trImageDPI = trN.DotsPerInch; //the name in all raster formats
				if(!trImageDPI)
					trImageDPI = trN.PostScript.DestRastOperRes; //the name of EPS
			}
			if(trImageDPI) //for some image ext, trImageDPI may be invalid, so check before use
				return trImageDPI.nVal;	
		}		
			
		//return 96;//the default DPI	
		return DEFAULT_RESOLUTION; /// Hong 10/19/07 v8.0728 IMPROVE_AND_CENTRALIZE_CODE
	}
	
	
	int 	GetColorDepth()
	{
		TreeNode trImageOptions = GetImageOptions();
		string strExt = GetImageTypeExtension();
		
		TreeNode trType = trImageOptions.GetNode(strExt, false);
		if(trType)
		{	
			TreeNode trColors = trType.BitsPerPixel;
			if(trColors)
				return trColors.nVal;
		}
		return 8; //default
	}
	
	int 	Getcompression()
	{
		TreeNode trImageOptions = GetImageOptions();
		string strExt = GetImageTypeExtension();
		
		TreeNode trType = trImageOptions.GetNode(strExt, false);
		if(trType)
		{		
			TreeNode trCompression = trType.Compression;//for JPG, TIF
			if(!trCompression)
				trCompression = trImageOptions.TIFF.DataCompression; //for AI
			
			if(trCompression && 0 == trCompression.GetNodeCount())		
				return trCompression.nVal;
		}
		
		return 0;		
	}
	
	bool	IsGraySacle()
	{
		TreeNode trImageOptions = GetImageOptions();
		string strExt = GetImageTypeExtension();
		
		TreeNode trType = trImageOptions.GetNode(strExt, false);
		if(trType)
		{		
			TreeNode	trBits = trType.BitsPerPixel;
			if(trBits)
			{	
				int 	nGray = 0;
				if(8 == trBits.nVal && trBits.GetAttribute(STR_ATTRIB_GRAY_SCALE, nGray) && 1 == nGray)
					return true;
			}
		}
		return false;
	}
	
	bool 	GetPageOriginalSize(const Page& pg, double& dWidth, double& dHeight, int* pUnits = NULL, TreeNode& trSettings = NULL)
	{
		// not implemented yet
		return true;
	}
	
	bool 	GetPageResolution(const GraphPageBase& gp, double& dWidthRes, double& dHeightRes)
	{
		// not implemented yet
		return true;	
	}
	
	///Kyle 08/23/2010 ORG-338-S1 SHOW_PAGE_ORIGINAL_SIZE_AS_HINT
	virtual bool	GetOriginalPageSize(Page& pg, double& dWidth, double& dHeight, int* pUnits = NULL)
	{
		ASSERT(0);
		return false;
	}
	///End SHOW_PAGE_ORIGINAL_SIZE_AS_HINT
	
	bool	ConvertSize(const Page& pg, double& dDestSize, int nDestUnit, double dSrcSize, int nSrcUnit, int* pnDPI = NULL, bool bWidth = true)
	{
		//SaveRestorePageSettings junk; 
		BackupPageSettings(pg);
		
		ApplyPageSettings(pg);
		
		double dTempSize;
		
		if ( UNIT_RATIO == nSrcUnit )
		{
			dSrcSize /= 100;
			_compute_page_export_inch(pg, dSrcSize, dTempSize, bWidth); // ratio to inches
			dSrcSize = dTempSize;
			nSrcUnit = UNIT_INCH;
		}	
		
		if ( UNIT_RATIO == nDestUnit )
		{
			if ( UNIT_INCH != nSrcUnit )
			{
				ConvertSize(dTempSize, UNIT_INCH, dSrcSize, nSrcUnit, pnDPI);
				dSrcSize = dTempSize;
				nSrcUnit = UNIT_INCH;
			}
			
			_compute_page_export_ratio(pg, &dDestSize, dSrcSize, bWidth); // inches to ratio
			dDestSize *= 100;
		}
		else
			ConvertSize(dDestSize, nDestUnit, dSrcSize, nSrcUnit, pnDPI);
		
		RestorePageSettings(pg);
		return true;
	}
	
	bool	GetProperSize(const Page& pg, double& dWidthSize, double& dHeightSize, int nUnit, bool bWidthChanged = true)
	{
		if ( UNIT_RATIO == nUnit )
		{
			if ( bWidthChanged )
				dHeightSize = dWidthSize;
			else
				dWidthSize = dHeightSize;
		}
		else
		{
			//SaveRestorePageSettings junk; 
			BackupPageSettings(pg);
			ApplyPageSettings(pg);
			
			RECT 	rect;
			double	dTempSize;
			_compute_page_export_inch(pg, 100/100, dTempSize, true, &rect); // just get rect
			
			if(bWidthChanged)
				dHeightSize = round(RECT_HEIGHT(rect) * dWidthSize / RECT_WIDTH(rect), DEFAULT_DECIMAL_PLACES);
			else
				dWidthSize = round(RECT_WIDTH(rect) * dHeightSize / RECT_HEIGHT(rect), DEFAULT_DECIMAL_PLACES);
			
			RestorePageSettings(pg);
		}
		
		return true;
	}
	
	bool	BackupPageSettings(Page& pg = NULL, int nLayerIndex = -1)
	{
		SaveRestorePageSettings* pSR = NULL;
		GetSaveRestoreObj(&pSR, pg, nLayerIndex);
	
		if ( pSR )
			vSaveRestoreObj.Add((DWORD)pSR);
		else
			vSaveRestoreObj.Add(0);
		
		return true;
	}
	bool	RestorePageSettings(Page& pg = NULL, int nLayerIndex = -1)
	{
		SaveRestorePageSettings* pSR = NULL;
		if ( vSaveRestoreObj.GetSize() > 0 )
		{
			DWORD dw = vSaveRestoreObj[vSaveRestoreObj.GetSize() - 1];
			if ( dw )
				pSR = (SaveRestorePageSettings*)dw;
			RemoveSaveRestoreObj(pSR);
			vSaveRestoreObj.RemoveAt(vSaveRestoreObj.GetSize() - 1);
		}	
		
		return true;
	}	
	
	virtual bool 	ApplyPageSettings(Page& pg = NULL, int nLayerIndex = -1)
	{
		TreeNode trMargin = m_trPageOptions.Margin;
		TreeNode trBorderWid = m_trPageOptions.BorderWid;
		if(!trMargin || !trBorderWid)
			return false;		
		
		OriginSettings os;
		os.SetValue("CopyPage.Closeness", trMargin.nVal);
		if(trBorderWid.Enable)
		{
			os.SetValue("CopyPage.ClipBorderw", trBorderWid.nVal);
		}
		TreeNode trAdv = m_trPageOptions.Advanced;
		if(trAdv && trAdv.Show)
		{
			os.SetValue("CopyPage.ADVANCED", 1);
			os.SetValue("CopyPage.ADVKEEPSIZE", trAdv.Resolution.nVal);
			os.SetValue("CopyPage.ADVRES", trAdv.DPI.nVal);
		}
		
		double	dRatio = 100;
		m_trPageSize.Width.GetAttribute(STR_RATIO_ATTRIB, dRatio);
		os.SetValue("CopyPage.RATIO", dRatio);
		
		return true;
	}	
	
	virtual bool	GetSaveRestoreObj(SaveRestorePageSettings** ppSR, Page& pg = NULL, int nLayerIndex = -1)
	{
		*ppSR = new SaveRestorePageSettings;
		
		return true;
	}	
	
	virtual bool	RemoveSaveRestoreObj(SaveRestorePageSettings* pSR, Page& pg = NULL, int nLayerIndex = -1)
	{
		if ( pSR )
			delete pSR;
		
		return true;
	}
	
	virtual void	SetGetNOptions(const TreeNode& trGetN) {ASSERT(false);}
	virtual void 	AfterChangedPageSelectionOption(TreeNode& trGetN, string* pstrErrMsg = NULL, bool* pbOK = NULL) {ASSERT(false);}
	
	virtual bool getSourcePage(LPCSTR lpcszPages, PageBase& pg, int* pnLayerIndex = NULL) { ASSERT(false); return false; }
	
	virtual bool getPreviewPage(const TreeNode& trGetN, PageBase& pg, bool& bTempCreated, int* pnLayerIndex = NULL) { ASSERT(false); return false; }
	/// Hong 07/21/09 QA80-13280-P4 WKS_EXPORT_MULTIPAGE_PDF_PAGE_BREAKS
	virtual bool checkUpdatePrintOpts(TreeNode& trGetN) { return false; }
	/// end WKS_EXPORT_MULTIPAGE_PDF_PAGE_BREAKS
	
	/// Hong 10/13/09 QA80-13280-S3 BETTER_PREDEFINE_FILE_NAME_LABEL_FOR_WKS
	virtual string getPredefinedFileName() { return _L("Graph##"); }
	/// end BETTER_PREDEFINE_FILE_NAME_LABEL_FOR_WKS
	
protected:
	//void pageClone(TreeNode& trGetN, PageBase& pgTemp)
	void pageClone(LPCSTR lpcszPages, PageBase& pgTemp)
	{
		PageBase pg;
		if( !getSourcePage(lpcszPages, pg) )
			return;
		GraphPageBase 	gpSource = pg;
	
		GraphPage	 pgNew(pgTemp);
		//----- CPY 10/27/2007 QA70-10605 OC_ACCESS_TO_PAGE_NOTSAVED_BITS
		//if(gpSource && pgNew)
		//{
		//	gpSource.CreateCopy(pgNew);		
		//	_page_disable_click(pgNew);
		//	pgNew.Refresh(true);
		//}
		/// Hong 11/05/07 v8.0740 FIX_EXP_GRAPH_FAIL_WITH_AXIS_SCROLLBAR
		//page_clone(gpSource, pgNew);
		//--------- CPY 5/6/08 QA70-11514 LAYOUT_PAGE_EXPORT_NOT_USING_WRONG_TEMP_PAGE_TYPE
		//cleanPageClone(gpSource, pgNew);
		page_clone(gpSource, pgNew);
		//---------
		/// end FIX_EXP_GRAPH_FAIL_WITH_AXIS_SCROLLBAR
		//-----
	}
	
	/// Hong 04/17/09 QA80-13280 SUPPORT_EXPORT_MULTI_PAGES_PDF
	TreeNode getPDFOptions(TreeNode& trImageOptions)
	{
		if ( !trImageOptions )
		{
			TreeNode	trPDF;
			return trPDF;
		}
		return trImageOptions.FindNodeByAttribute(STR_ATTRIB_IMAGE_TYPE, "PDF", false); // Hong, this knowledge comes from export_gui_show_options_branch
	}
	/// end SUPPORT_EXPORT_MULTI_PAGES_PDF
	
private:
	//--------- CPY 5/6/08 QA70-11514 LAYOUT_PAGE_EXPORT_NOT_USING_WRONG_TEMP_PAGE_TYPE
	/*
	/// Hong 11/05/07 v8.0740 FIX_EXP_GRAPH_FAIL_WITH_AXIS_SCROLLBAR
	void cleanPageClone(GraphPageBase& gpSource, GraphPageBase& pgDest)
	{
		page_clone(gpSource, pgDest);
		
		if ( pgDest )
		{
			remove_axis_scrollbar(pgDest);
		}			
	}
	/// end FIX_EXP_GRAPH_FAIL_WITH_AXIS_SCROLLBAR
	*/
	//---------- end LAYOUT_PAGE_EXPORT_NOT_USING_WRONG_TEMP_PAGE_TYPE
	bool convertInchToRatio(GraphPageBase& gp, double &dRatio, double dInches, BOOL bWidth = true, TreeNode& trSettings = NULL);
	bool convertRatioToInch(GraphPageBase& gp, double &dInches, double dRatio, BOOL bWidth = true, TreeNode& trSettings = NULL);
	bool getPageRectLogical(GraphPageBase& gp, RECT *prRectLogical, TreeNode& trSettings = NULL);

// for GETN tree
private:
	void guiUpdateSizeControls(TreeNode& trGetN, LPCSTR lpcszNodeName)
	{
		//---- Iris 11/06/06 MOVE_RATIO_TO_INSIDE_WIDTH, id attribute may be removed for one of Ratio & Width tree node in order to not save into theme
		//TreeNode 	trRatio = tree_get_node_by_id(trGetN, PAGE_RATIO, true);
		TreeNode 	trUnit = tree_get_node_by_id(trGetN, PAGE_UNIT, true);
		//----
		TreeNode 	trRescaling = tree_get_node_by_id(trGetN, PAGE_RESCALING, true);
		TreeNode 	trWidth = tree_get_node_by_id(trGetN, PAGE_WIDTH, true);
		TreeNode 	trHeight = tree_get_node_by_id(trGetN, PAGE_HEIGHT, true);
	 	TreeNode 	trCurrentSize = tree_get_node_by_id(trGetN, PAGE_CUR_SIZE, true); ///---Sim 08-22-2007 SHOW_CURRENT_SIZE_WHEN_CHANGE_PERCENT
		if(!trWidth || !trHeight || !trUnit || !trRescaling)
		{
			error_report("Found invalid treenode in _gui_update_size_controls");
			return;	
		}
		
		bool 		bChangeUnit = 0 == lstrcmp(lpcszNodeName, "Unit");
		bool 		bChangeWidth = 0 == lstrcmp(lpcszNodeName, "Width");
		bool		bChangeHeight = 0 == lstrcmp(lpcszNodeName, "Height");
		/// Iris 07/02/2007 v8.0653 SIZE_ON_GUI_IS_NOT_CONSISTENT_WITH_EXPORTED_SIZE
		bool		bChangeMargin = 0 == lstrcmp(lpcszNodeName, "Margin");
		bool		bChangeBorderWid = 0 == lstrcmp(lpcszNodeName, "BorderWid");
		bool		bChangePageTheme = 0 == lstrcmp(lpcszNodeName, "theme"); 
		///end SIZE_ON_GUI_IS_NOT_CONSISTENT_WITH_EXPORTED_SIZE
		///Kyle 08/23/2010 ORG-338-S1 SHOW_PAGE_ORIGINAL_SIZE_AS_HINT
		bool		bChangeArea = 0 == lstrcmp(lpcszNodeName, "Area");			// for export wks as image
		///End SHOW_PAGE_ORIGINAL_SIZE_AS_HINT
		
		///Kyle 07/07/2010 ORG-338-P1 AUTO_WIDTH_HEIGHT_FOR_EXPORT_GRAPH, no used
		/*
		int		 	nOriginlabUnit;
		trUnit.GetAttribute(STR_ORIGINAL_UNIT_ATTRIB, nOriginlabUnit);
		double 		dOriginalWidth, dOriginalHeight;
		trWidth.GetAttribute(NUM_ORIGINAL_SIZE, dOriginalWidth);
		trHeight.GetAttribute(NUM_ORIGINAL_SIZE, dOriginalHeight);	
		*/
		///End AUTO_WIDTH_HEIGHT_FOR_EXPORT_GRAPH
		
		//must computer the Ratio of Width & Height whatever Unit changed or Width changed since will write to OriginSettings to do export
		int			nDPI = GetDPI();
		int			nOldUnit = -1;
		if( !trWidth.GetAttribute(STR_UNIT_ATTRIB, nOldUnit) )
			return;
		
		int		nNewUnit = _convert_gui_unit_to_page_unit(trUnit.nVal);
		/// Hong 11/01/07 v8.0738 CENTRALIZE_CODE_OF_GET_PREVIEW_PAGE
		/*
		Page	pg;
		GraphPage gp;
		bool	bTempCreated = false;		
		if(EXIST_WKS == GetPageType())
		{
			getSourcePage(trGetN.pages.strVal, pg);
		}
		else
		{
			bTempCreated = true;
			gp.Create(NULL, CREATE_SET_MISSING_IN_MANAGER);
			
			//pageClone(trGetN, gp); //get source graph and make clone to pgTemp
			pageClone(trGetN.pages.strVal, gp); //get source graph and make clone to pgTemp
			pg = gp;
		}
		*/
		Page	pg;
		bool	bTempCreated = false;	
		getPreviewPage(trGetN, pg, bTempCreated);
		/// end CENTRALIZE_CODE_OF_GET_PREVIEW_PAGE
		
		///Kyle 07/07/2010 ORG-338-P1 AUTO_WIDTH_HEIGHT_FOR_EXPORT_GRAPH
		bool bAutoSize = 	(rescaling_width==trRescaling.nVal && 1==octree_get_auto_support(&trWidth)) ||
							(rescaling_width!=trRescaling.nVal && 1==octree_get_auto_support(&trHeight));
		///End AUTO_WIDTH_HEIGHT_FOR_EXPORT_GRAPH

		///Kyle 08/24/2010 ORG-338-P4 UPDATE_AUTO_WIDTH_AND_HEIGHT_ON_RESCALING_CHANGE
		if( 0 == lstrcmp(lpcszNodeName, "Rescaling") && bAutoSize )
		{
			bChangeWidth = (rescaling_width==trRescaling.nVal);
			bChangeHeight = (rescaling_height==trRescaling.nVal);
		}
		///End UPDATE_AUTO_WIDTH_AND_HEIGHT_ON_RESCALING_CHANGE
	
		if ( bChangeUnit && nOldUnit != nNewUnit )
		{
			if(UNIT_RATIO == nNewUnit)
			{
				double	dRatio;
				double		dWidthInches, dHeightInches;
				///Kyle 07/07/2010 ORG-338-P1 AUTO_WIDTH_HEIGHT_FOR_EXPORT_GRAPH
				/*
				ConvertSize(dWidthInches, UNIT_INCH, trWidth.dVal, nOldUnit, &nDPI);
				ConvertSize(dHeightInches, UNIT_INCH, trHeight.dVal, nOldUnit, &nDPI);
				
				string strSize; ///---Sim 08-22-2007 SHOW_CURRENT_SIZE_WHEN_CHANGE_PERCENT
				BOOL 	bRet = ConvertSize(pg, dRatio, UNIT_RATIO, dWidthInches, UNIT_INCH, &nDPI, true);
				*/
				BOOL 	bRet = false;
				if( bAutoSize )
				{
					dRatio = 100;
					ConvertSize(pg, dWidthInches, UNIT_INCH, dRatio, UNIT_RATIO, &nDPI, true);
					ConvertSize(pg, dHeightInches, UNIT_INCH, dRatio, UNIT_RATIO, &nDPI, false);
					bRet = true;
				}
				else
				{
					ConvertSize(dWidthInches, UNIT_INCH, trWidth.dVal, nOldUnit, &nDPI);
					ConvertSize(dHeightInches, UNIT_INCH, trHeight.dVal, nOldUnit, &nDPI);
					bRet = ConvertSize(pg, dRatio, UNIT_RATIO, dWidthInches, UNIT_INCH, &nDPI, true);
				}
				string strSize;
				///End AUTO_WIDTH_HEIGHT_FOR_EXPORT_GRAPH
				if(bRet)
				{
					//dRatio = dRatio*100;
					trWidth.dVal = round(dRatio, DEFAULT_DECIMAL_PLACES);
					trHeight.dVal = round(dRatio, DEFAULT_DECIMAL_PLACES);
					trWidth.SetAttribute(STR_RATIO_ATTRIB, dRatio);
					
					strSize.Format(STR_CURRENT_SIZE, dWidthInches, dHeightInches); ///---Sim 08-22-2007 SHOW_CURRENT_SIZE_WHEN_CHANGE_PERCENT
				}
				
				trCurrentSize.strVal = strSize; ///---Sim 08-22-2007 SHOW_CURRENT_SIZE_WHEN_CHANGE_PERCENT			
			}
			else
			{
				double dNewWidth, dNewHeight;
				ConvertSize(pg, dNewWidth, nNewUnit, trWidth.dVal, nOldUnit, &nDPI, true);
				ConvertSize(pg, dNewHeight, nNewUnit, trHeight.dVal, nOldUnit, &nDPI, false);
				
				if(UNIT_PIXEL == nNewUnit)
				{
					trWidth.dVal = nint(dNewWidth);
					trHeight.dVal = nint(dNewHeight);
				}
				else
				{
					trWidth.dVal = round(dNewWidth, DEFAULT_DECIMAL_PLACES);
					trHeight.dVal = round(dNewHeight, DEFAULT_DECIMAL_PLACES);
				}				
			}
			trWidth.SetAttribute(STR_UNIT_ATTRIB, nNewUnit);
		}
		
		///Kyle 08/23/2010 ORG-338-S1 SHOW_PAGE_ORIGINAL_SIZE_AS_HINT
		if( bChangeMargin || bChangePageTheme )
		{
			TreeNode trMargin = tree_get_node_by_id(trGetN, PAGE_MARGIN_CONTROL, true);
			if( trMargin )
			{
				TreeNode 	trPageSettings = GetPageSize();
				if( trPageSettings.ActualSize )
					trPageSettings.ActualSize.Show = trMargin.nVal != 2;		// 2: Page
			}
		}
		///End SHOW_PAGE_ORIGINAL_SIZE_AS_HINT
	
		// the change of Margin and Border Wid also effected Width and Height, so if Width is specified by user, Height should recalculate.
		///Kyle 08/23/2010 ORG-338-S1 SHOW_PAGE_ORIGINAL_SIZE_AS_HINT
		//if(bChangeMargin || bChangeBorderWid || bChangePageTheme)
		if( bChangeMargin || bChangeBorderWid || bChangePageTheme || bChangeArea )
		///End SHOW_PAGE_ORIGINAL_SIZE_AS_HINT
		{
			///Kyle 07/07/2010 ORG-338-P1 AUTO_WIDTH_HEIGHT_FOR_EXPORT_GRAPH, update gui actual size, moved from guiInitPageSettings()
			int nOrigUnit = UNIT_INCH;
			trUnit.GetAttribute(STR_ORIGINAL_UNIT_ATTRIB, nOrigUnit);
			
			double dOrigWidth, dOrigHeight;
			ConvertSize(pg, dOrigWidth, nOrigUnit, 100, UNIT_RATIO, &nDPI, true);
			ConvertSize(pg, dOrigHeight, nOrigUnit, 100, UNIT_RATIO, &nDPI, false);

			string strUnits = _unit_int_to_str(nOrigUnit);
			if( !strUnits.IsEmpty() )
			{
				TreeNode 	trPageSettings = GetPageSize();
				if( trPageSettings.ActualSize )
				{
					string strSize;
					strSize.Format(_L("Width %.2f %s x Height %.2f %s"), dOrigWidth, strUnits, dOrigHeight, strUnits);
					trPageSettings.ActualSize.strVal = strSize;
				}
			}
			///End AUTO_WIDTH_HEIGHT_FOR_EXPORT_GRAPH

			bChangeWidth = rescaling_width == trRescaling.nVal? true : false;
			bChangeHeight = !bChangeWidth;
		}
		
		if(bChangeWidth || bChangeHeight)
		{					
			double dWidth, dHeight;
			///Kyle 07/07/2010 ORG-338-P1 AUTO_WIDTH_HEIGHT_FOR_EXPORT_GRAPH
			//dWidth = trWidth.dVal;
			//dHeight = trHeight.dVal;
			//GetProperSize(pg, dWidth, dHeight, nNewUnit, bChangeWidth);
			if( bAutoSize )
			{
				double dRatio = 100;
				if( UNIT_RATIO == nNewUnit )
					dWidth = dHeight = dRatio;
				else
				{
					ConvertSize(pg, dWidth, nNewUnit, dRatio, UNIT_RATIO, &nDPI, true);
					ConvertSize(pg, dHeight, nNewUnit, dRatio, UNIT_RATIO, &nDPI, false);
				}
			}
			else
			{
				dWidth = trWidth.dVal;
				dHeight = trHeight.dVal;
				GetProperSize(pg, dWidth, dHeight, nNewUnit, bChangeWidth);
			}
			///End AUTO_WIDTH_HEIGHT_FOR_EXPORT_GRAPH
			trWidth.dVal = dWidth;
			trHeight.dVal = dHeight;
			//right now display unit is always inch
			double dWidthInches, dHeightInches;
			ConvertSize(pg, dWidthInches, UNIT_INCH, trWidth.dVal, nNewUnit, &nDPI, true);
			ConvertSize(pg, dHeightInches, UNIT_INCH, trHeight.dVal, nNewUnit, &nDPI, false);
			
			string strSize;
			strSize.Format(STR_CURRENT_SIZE, dWidthInches, dHeightInches); 
			trCurrentSize.strVal = strSize;
		}		
		
		if(bTempCreated)
			//gp.Destroy();
			pg.Destroy(); /// Hong 11/01/07 v8.0738 CENTRALIZE_CODE_OF_GET_PREVIEW_PAGE
	}
	
	bool getImageFileTypeDescripAndExt(string& strType, string& strExt)
	{
		string strDescrip = GetImageTypeDescription();
		
		int nLastPeriod = strDescrip.ReverseFind('.');
		int nLastPeren = strDescrip.ReverseFind(')');
		if( nLastPeriod < 0 || nLastPeren <= nLastPeriod )
			return false;
		
		strType = strDescrip;
		strExt = strDescrip.Mid(nLastPeriod + 1, nLastPeren - nLastPeriod - 1);
		return true;
	}
	
	//int getSourcePageType(TreeNode& trGetN)
	int getSourcePageType(LPCSTR lpcszPages)
	{
		int				nPageType = EXIST_PLOT;

		PageBase 	pgSource;	
		if( getSourcePage(lpcszPages, pgSource) )
			nPageType = pgSource.GetType();		
		

		return nPageType;
	}
		
	
	bool getSourcePageSize(LPCSTR lpcszPages, double& dWidth, double& dHeight, int* pUnits = NULL)
	{
		///Kyle 07/07/2010 ORG-338-P1 AUTO_WIDTH_HEIGHT_FOR_EXPORT_GRAPH
		/*
		TreeNode trPageSize = GetPageSize();
		if( trPageSize.Width.GetAttribute(NUM_ORIGINAL_SIZE, dWidth) && trPageSize.Height.GetAttribute(NUM_ORIGINAL_SIZE, dHeight) )
		{
			if(NULL != pUnits)
			{
				int nUnits;
				trPageSize.Unit.GetAttribute(STR_ORIGINAL_UNIT_ATTRIB, nUnits);
				*pUnits = nUnits;
			}
			return true;	
		}	
		*/
		///End AUTO_WIDTH_HEIGHT_FOR_EXPORT_GRAPH
		
		Page	pg;	
		if( !getSourcePage(lpcszPages, pg) )
			return false;
		
		///Kyle 08/23/2010 ORG-338-S1 SHOW_PAGE_ORIGINAL_SIZE_AS_HINT
		//if( !_get_page_size(pg, dWidth, dHeight, pUnits) )
		if( !GetOriginalPageSize(pg, dWidth, dHeight, pUnits) )
		///End SHOW_PAGE_ORIGINAL_SIZE_AS_HINT
			return false;
		
		/// Iris 11/17/2008 v8.0973 QA80-12597 FIX_CANNOT_EXPORT_GRAPH_IF_UNIT_IS_POINT_OR_MM
		if(pUnits)
		{
			if( _convert_page_unit_to_gui_unit(*pUnits) < 0 )
			{
				int nDefaultUnit = DEFAULT_UNIT_INCH;
				if( ConvertSize(dWidth, nDefaultUnit, dWidth, *pUnits) && ConvertSize(dHeight, nDefaultUnit, dHeight, *pUnits))
					*pUnits = nDefaultUnit;
			}
		}
		///END FIX_CANNOT_EXPORT_GRAPH_IF_UNIT_IS_POINT_OR_MM
		
		dWidth = round(dWidth, DEFAULT_DECIMAL_PLACES);
		dHeight = round(dHeight, DEFAULT_DECIMAL_PLACES);
		return true;	
	}

	//void guiInitPageSettings(TreeNode& trGetN)
	///---Sim 12-24-2008 QA80-12853 FIX_SHOW_RASTER_IMAGE_PIXEL_SIZE_WHEN_RATIO_UNIT
	//void guiInitPageSettings(LPCSTR lpcszPages)
	void guiInitPageSettings(TreeNode& trGetN, LPCSTR lpcszPages)
	///---END QA80-12853 FIX_SHOW_RASTER_IMAGE_PIXEL_SIZE_WHEN_RATIO_UNIT
	{	
		//TreeNode 	trPageSettings = trGetN.tr1;
		TreeNode 	trPageSettings = GetPageSize();
		if(!trPageSettings)
			return;
		
		TreeNode	trUnit = trPageSettings.Unit;
		TreeNode 	trWidth = trPageSettings.Width;
		TreeNode 	trHeight = trPageSettings.Height;
		if(!trUnit || !trWidth || !trHeight)
			return;
		
		int			nUnits = -1;
		double 		dWidth, dHeight;
		string		strUnits;
		
		if(getSourcePageSize(lpcszPages, dWidth, dHeight, &nUnits))
		{	
			///Kyle 07/07/2010 ORG-338-P1 AUTO_WIDTH_HEIGHT_FOR_EXPORT_GRAPH
			/*
			//save original page size to Width/Height treenode as attribute, will be very useful later
			trWidth.SetAttribute(NUM_ORIGINAL_SIZE, dWidth);
			trWidth.SetAttribute(STR_UNIT_ATTRIB, nUnits);
			trWidth.SetAttribute(STR_RATIO_ATTRIB, 100);
			trHeight.SetAttribute(NUM_ORIGINAL_SIZE, dHeight);	
			trUnit.SetAttribute(STR_ORIGINAL_UNIT_ATTRIB, nUnits);

			if(0 == trWidth.dVal)
			{
				trUnit.nVal = nUnits;
				trWidth.dVal = round(dWidth, DEFAULT_DECIMAL_PLACES);
				trHeight.dVal = round(dHeight, DEFAULT_DECIMAL_PLACES);
			}
			///---Sim 07-06-2007 FIX_CHANGE_UNIT_ISSUE
			else if ( trWidth.dVal > 0)
			{
				trWidth.SetAttribute(STR_UNIT_ATTRIB, _convert_gui_unit_to_page_unit(trUnit.nVal));
			}
			///---END FIX_CHANGE_UNIT_ISSUE

			strUnits = _unit_int_to_str(nUnits);
			if( !strUnits.IsEmpty() )
			{
				string strSize;
				strSize.Format(_L("Width %.2f %s x Height %.2f %s"), dWidth, strUnits, dHeight, strUnits);
				if(trPageSettings.ActualSize)
					trPageSettings.ActualSize.strVal = strSize;			
			}			
			///---Sim 08-22-2007 SHOW_CURRENT_SIZE_WHEN_CHANGE_PERCENT
			if(GUI_UNIT_RATIO == trUnit.nVal)
			{
				trPageSettings.CurrentSize.Show = true; 
			}
			else
				trPageSettings.CurrentSize.Show = false; 
			///---END SHOW_CURRENT_SIZE_WHEN_CHANGE_PERCENT
			*/
			///Kyle 08/23/2010 ORG-338-S1 SHOW_PAGE_ORIGINAL_SIZE_AS_HINT
			string strUnits = _unit_int_to_str(nUnits);
			if( trPageSettings.OrigSize && !strUnits.IsEmpty() )
			{
				string strSize;
				strSize.Format(_L("Width %.2f %s x Height %.2f %s"), dWidth, strUnits, dHeight, strUnits);
				trPageSettings.OrigSize.strVal = strSize;
			}
			///End SHOW_PAGE_ORIGINAL_SIZE_AS_HINT

			trUnit.SetAttribute(STR_ORIGINAL_UNIT_ATTRIB, nUnits);		// use this to update the actual size
			trWidth.SetAttribute(STR_RATIO_ATTRIB, 100);

			if(0 == trWidth.dVal)		// on init, get page unit
				trUnit.nVal = nUnits;
			trWidth.SetAttribute(STR_UNIT_ATTRIB, _convert_gui_unit_to_page_unit(trUnit.nVal));

			trPageSettings.CurrentSize.Show = (GUI_UNIT_RATIO == trUnit.nVal);
	
			guiUpdateSizeControls(trGetN, "theme");
			///End AUTO_WIDTH_HEIGHT_FOR_EXPORT_GRAPH
		}
		
		///---Sim 12-24-2008 QA80-12853 FIX_SHOW_RASTER_IMAGE_PIXEL_SIZE_WHEN_RATIO_UNIT
		//updatePixelSizeControl(true);
		updatePixelSizeControl(trGetN, true);
		///---END QA80-12853 FIX_SHOW_RASTER_IMAGE_PIXEL_SIZE_WHEN_RATIO_UNIT
		
		//_update_advanced_options(trGetN.tr);
		_update_advanced_options( GetPageOptions() );
	}
	
	///---Sim 12-24-2008 QA80-12853 FIX_SHOW_RASTER_IMAGE_PIXEL_SIZE_WHEN_RATIO_UNIT
	//void updatePixelSizeControl(bool bPageChanged)
	void updatePixelSizeControl(TreeNode& trGetN, bool bPageChanged)
	///---END QA80-12853 FIX_SHOW_RASTER_IMAGE_PIXEL_SIZE_WHEN_RATIO_UNIT
	{
		TreeNode 	trPageSettings = GetPageSize();
		TreeNode 	trPixelSize = trPageSettings.PixelSize;
		string strType, strExt;	
		getImageFileTypeDescripAndExt(strType, strExt);
		bool	bShow = is_image_file_type_ext(strExt, IFT_RASTER);
		trPixelSize.Show = bShow;
		if( !bShow )
			return;
		
		///---Sim 12-24-2008 QA80-12853 FIX_SHOW_RASTER_IMAGE_PIXEL_SIZE_WHEN_RATIO_UNIT
		//GraphPageBase	gp;
		Page pg;
		bool	bTempCreated = false;	
		getPreviewPage(trGetN, pg, bTempCreated);
		///---END QA80-12853 FIX_SHOW_RASTER_IMAGE_PIXEL_SIZE_WHEN_RATIO_UNIT
		double		xx, yy;
		double		dWidthOnPixel, dHeightOnPixel;

		int 	nDPI = GetDPI();
		int		nUnits = _convert_gui_unit_to_page_unit(trPageSettings.Unit.nVal);
		///---Sim 12-24-2008 QA80-12853 FIX_SHOW_RASTER_IMAGE_PIXEL_SIZE_WHEN_RATIO_UNIT
		//ConvertSize(gp, dWidthOnPixel, UNIT_PIXEL, trPageSettings.Width.dVal, nUnits, &nDPI, true);
		//ConvertSize(gp, dHeightOnPixel, UNIT_PIXEL, trPageSettings.Height.dVal, nUnits, &nDPI, false);	
		ConvertSize(pg, dWidthOnPixel, UNIT_PIXEL, trPageSettings.Width.dVal, nUnits, &nDPI, true);
		ConvertSize(pg, dHeightOnPixel, UNIT_PIXEL, trPageSettings.Height.dVal, nUnits, &nDPI, false);	
		///---END QA80-12853 FIX_SHOW_RASTER_IMAGE_PIXEL_SIZE_WHEN_RATIO_UNIT
		
		string strPixel;
		strPixel.Format(_L("Width %.0f x Height %.0f"), dWidthOnPixel, dHeightOnPixel);

		trPixelSize.strVal = strPixel;
		trPixelSize.SetAttribute(STR_PIXEL_WIDTH, dWidthOnPixel);
		trPixelSize.SetAttribute(STR_PIXEL_HEIGHT, dHeightOnPixel);
		
		///---Sim 12-24-2008 QA80-12853 FIX_SHOW_RASTER_IMAGE_PIXEL_SIZE_WHEN_RATIO_UNIT
		if(bTempCreated)
			pg.Destroy();
		///---END QA80-12853 FIX_SHOW_RASTER_IMAGE_PIXEL_SIZE_WHEN_RATIO_UNIT
	}
	
	bool checkSourcePage(TreeNode& trGetN, string& strErrMsg, bool& bOKEnable, int* pnPageType = NULL)
	{
		PageBase		pg;
		
		if( !getSourcePage(trGetN.pages.strVal, pg) )
		{
			strErrMsg = CER_INVALID_GRAPH;
			bOKEnable = false;
			return false;
		}
		
		if(pnPageType)
			*pnPageType = pg.GetType();
		
		return true;
	}

	void updateType(TreeNode& trGetN)
	{
		if ( SetImageType(_gui_get_image_type(trGetN)) )
		{
			string strType, strExt;
			getImageFileTypeDescripAndExt(strType, strExt);
			
			gui_after_type_changed(trGetN, strExt);
		}
	}
	
	/// Hong 04/17/09 QA80-13280 SUPPORT_EXPORT_MULTI_PAGES_PDF
	//int exportPage(const Page& pg, int nLayerIndex, LPCSTR lpcszFileName, LPCSTR lpcszExt, string& strErrMsg, LPCSTR lpcszMoreExt = NULL, bool bIsPreview = false, bool bSystem = false, bool bSource = true, bool bUpdateRatio = false)
	int exportPage(const Page& pg, int nLayerIndex, LPCSTR lpcszFileName, LPCSTR lpcszExt, string& strErrMsg, LPCSTR lpcszMoreExt = NULL, bool bIsPreview = false, bool bSystem = false, 
					bool bSource = true, bool bUpdateRatio = false, bool bMultiPgPDF = false)
	/// end SUPPORT_EXPORT_MULTI_PAGES_PDF
	{
		if(!pg || nLayerIndex >=pg.Layers.Count() || !pg.Layers(nLayerIndex) )	
			return CER_INVALID_GRAPH;
		
		TreeNode trExportOptions, trPageOptions, trImageOptions;
		trExportOptions = GetPageOptions();
		trPageOptions = GetPageSize();
		trImageOptions = GetImageOptions();
		
		string 	strExt(lpcszExt);
		if(!trPageOptions)
		{
			strErrMsg = "Page ";
			return XFERR_GET_SETTING;//-1;
		}
		if(!trImageOptions)
		{
			strErrMsg = "Image ";
			return XFERR_GET_SETTING;//-1;
		}
		
		BackupPageSettings(pg, nLayerIndex);
		if(!bSystem)
			ApplyPageSettings(pg, nLayerIndex);
		
		///Kyle 07/07/2010 ORG-338-P1 AUTO_WIDTH_HEIGHT_FOR_EXPORT_GRAPH, moved into ApplyPageSettings()
		/*
		double 		dRatio;
		TreeNode 	trWidth = tree_get_node_by_id(trPageOptions, PAGE_WIDTH, true);
		TreeNode 	trUnit = tree_get_node_by_id(trPageOptions, PAGE_UNIT, true);
		if(GUI_UNIT_RATIO == trUnit.nVal)
		{
			dRatio = trWidth.dVal;
		}
		else
		{
			if(bUpdateRatio)
			{
				int 	nDPI = GetDPI();
				int		nUnit = _convert_gui_unit_to_page_unit(trUnit.nVal);

				ConvertSize(pg, dRatio, UNIT_RATIO, trWidth.dVal, nUnit, &nDPI, true);
			}
		}
		*/
		TreeNode	trUnit = trPageOptions.Unit;
		TreeNode 	trRescaling = trPageOptions.Rescaling;
		TreeNode 	trWidth = trPageOptions.Width;
		TreeNode 	trHeight = trPageOptions.Height;
		ASSERT( trUnit && trRescaling && trWidth && trHeight );

		double 		dRatio = 100;
		if( trUnit && trRescaling && trWidth && trHeight )
		{
			if(GUI_UNIT_RATIO == trUnit.nVal)
			{
				if( 1 != octree_get_auto_support(&trWidth) )
					dRatio = trWidth.dVal;
			}
			else
			{
				bool	bWidth = rescaling_width == trRescaling.nVal;
				if( (bWidth && 1!=octree_get_auto_support(&trWidth)) || (!bWidth && 1!=octree_get_auto_support(&trHeight)) )	// not auto
				{
					int 	nDPI = GetDPI();
					int		nUnit = _convert_gui_unit_to_page_unit(trUnit.nVal);
					ConvertSize(pg, dRatio, UNIT_RATIO, bWidth ? trWidth.dVal : trHeight.dVal, nUnit, &nDPI, bWidth);
				}
			}
		}
		///End AUTO_WIDTH_HEIGHT_FOR_EXPORT_GRAPH
		trWidth.SetAttribute(STR_RATIO_ATTRIB, dRatio);

		/// Iris 06/18/2007 v8.0643 FIX_THE_RATIO_COMPUTED_ABOVE_NOT_USED_IN_EXPORT
		// When do export, the image size will be decided by Ratio saved in OriginSettings.
		// _update_origin_page_settings saved many settings including ratio to OriginSettings, but Ratio must computed by gp.ComputeNeededExportRatio above, and this method need to access real some page settings from OriginSettings
		// So need to separately write Ratio to OriginSettings here again. 
		// No need to take care write back the original Ratio since SaveRestorePageSettings above will auto do this.
		OriginSettings	os;
		os.SetValue("CopyPage.RATIO", dRatio);
		/// end FIX_THE_RATIO_COMPUTED_ABOVE_NOT_USED_IN_EXPORT

		TreeNode trExpTempOptions = trImageOptions.GetNode(strExt, false);
			
		/// EJP 2006-10-04 v8.0493 USE_CORRECT_KEY_NAMES_USED_BY_OIMG
		if( 0 == strExt.CompareNoCase("TIF") )
		{
			convert_node_value_from_str_to_index(trExpTempOptions.ColorSpace, STR_COMBO_ATTRIB);
			convert_node_value_from_str_to_index(trExpTempOptions.Compression, STR_COMBO_ATTRIB);
		}
		/// end USE_CORRECT_KEY_NAMES_USED_BY_OIMG	
		
		/// Iris 12/04/06 FIX_GRAY_SCALE_FAIL_TO_WORK
		if( trExpTempOptions )
		{
			convert_color_depth_from_str_to_num(trExpTempOptions.BitsPerPixel);
		}
		
		if( 0 == strExt.CompareNoCase("AI") )
		{
			convert_node_value_from_str_to_index(trExpTempOptions.TIFF.DataCompression, STR_COMBO_ATTRIB);
		}
		///end FIX_GRAY_SCALE_FAIL_TO_WORK	
		
		// write export settings to ini before export page
		tree_write_image_export_settings(trExpTempOptions, strExt);
	
		/// Hong 04/17/09 QA80-13280 SUPPORT_EXPORT_MULTI_PAGES_PDF
	 	//int nErr = exportPageToImage(pg, nLayerIndex, strExt, strErrMsg, lpcszFileName, lpcszMoreExt, bIsPreview);
	 	int nErr = exportPageToImage(pg, nLayerIndex, strExt, strErrMsg, lpcszFileName, lpcszMoreExt, bIsPreview, bMultiPgPDF);
	 	/// end SUPPORT_EXPORT_MULTI_PAGES_PDF
	 	/// Hong 06/01/09 REMOVE_BINARY_STORAGE_AFTER_EXPGRAPH_WHICH_IS_NOT_USED_ANYMORE
	 	// Hong, this may be old mechanism from 7.5, said iris, and after search, i find it's NOT used anywhere, so remove it suggested by Marko
#ifndef			REMOVE_EXPGRAPH_NOT_USED_BINARY_STORAGE
		/// end REMOVE_BINARY_STORAGE_AFTER_EXPGRAPH_WHICH_IS_NOT_USED_ANYMORE
		if( 0 == nErr )
			tree_set_page_image_export_settings(trExpTempOptions, pg, strExt); //write export settings into page info
#endif			//REMOVE_EXPGRAPH_NOT_USED_BINARY_STORAGE /// Hong 06/01/09 REMOVE_BINARY_STORAGE_AFTER_EXPGRAPH_WHICH_IS_NOT_USED_ANYMORE
		

		if( 0 == strExt.CompareNoCase("TIF") )
		{
			convert_node_value_from_index_to_str(trExpTempOptions.ColorSpace, STR_COMBO_ATTRIB);
			convert_node_value_from_index_to_str(trExpTempOptions.Compression, STR_COMBO_ATTRIB);
		}
		/// end USE_CORRECT_KEY_NAMES_USED_BY_OIMG
		
		/// Iris 12/04/06 FIX_GRAY_SCALE_FAIL_TO_WORK
		if( trExpTempOptions )
		{
			convert_color_depth_from_num_to_str(trExpTempOptions.BitsPerPixel);
		}
		
		if( 0 == strExt.CompareNoCase("AI") )
		{
			convert_node_value_from_index_to_str(trExpTempOptions.TIFF.DataCompression, STR_COMBO_ATTRIB);
		}

		RestorePageSettings(pg, nLayerIndex);
		return nErr;
	}
	
	/// Hong 04/17/09 QA80-13280 SUPPORT_EXPORT_MULTI_PAGES_PDF
	//int exportPageToImage(const Page& pg, int nLayerIndex, LPCSTR lpcszExt, string& strErrMsg, LPCSTR lpcszFileName, LPCSTR lpcszMoreExt = NULL, bool bIsPreview = false)
	int exportPageToImage(const Page& pg, int nLayerIndex, LPCSTR lpcszExt, string& strErrMsg, LPCSTR lpcszFileName, LPCSTR lpcszMoreExt = NULL, bool bIsPreview = false, bool bMultiPgPDF = false)
	/// end SUPPORT_EXPORT_MULTI_PAGES_PDF
	{
		TreeNode trExportOptions, trPageSettings, trImageOptions;
		trExportOptions = GetPageOptions();
		trPageSettings = GetPageSize();
		trImageOptions = GetImageOptions();
		
		if(!pg || nLayerIndex >= pg.Layers.Count() || !pg.Layers(nLayerIndex) )
			return CER_INVALID_GRAPH;
		
		string   	strExt(lpcszExt);
		if(strExt.IsEmpty() || 0 == lstrlen(lpcszFileName))
			return CER_INVALID_FILENAME;
		
		char 		strFileName[MAXFULLPATH];
		///------ Folger 05/12/09 QA80-13571-P1-P2 EXPORT_GRAPH_WITH_VERY_LONG_PATH_CRASH_ORIGIN
		//lstrcat(strFileName, lpcszFileName);
		lstrcpyn(strFileName, lpcszFileName, MAXFULLPATH);
		///------ End EXPORT_GRAPH_WITH_VERY_LONG_PATH_CRASH_ORIGIN
		check_add_file_ext(strFileName, strExt);
		
		///Kyle 07/07/2010 ORG-338-P1 AUTO_WIDTH_HEIGHT_FOR_EXPORT_GRAPH
		/*
		double	dWidth = trPageSettings.Width.dVal;
		double	dHeight = trPageSettings.Height.dVal;
		int		nUnits = _convert_gui_unit_to_page_unit(trPageSettings.Unit.nVal);
		*/
		TreeNode trWidth = trPageSettings.Width;
		TreeNode trHeight = trPageSettings.Height;

		double	dWidth = trWidth.dVal;
		double	dHeight = trHeight.dVal;
		int		nUnits = _convert_gui_unit_to_page_unit(trPageSettings.Unit.nVal);

		bool	bWidth = rescaling_width == trPageSettings.Rescaling.nVal;
		if( (bWidth && 1==octree_get_auto_support(&trWidth)) || (!bWidth && 1==octree_get_auto_support(&trHeight)) )	// auto
		{
			dWidth = dHeight = 100;
			nUnits = UNIT_RATIO;
		}
		///End AUTO_WIDTH_HEIGHT_FOR_EXPORT_GRAPH

		if( dWidth <= 0 || dHeight <= 0 || nUnits < 0)
			return CER_INVALID_SIZE;
		
		int nDPI;
		if(bIsPreview)
			nDPI = GetDPI(lpcszMoreExt);	
		else
			nDPI = GetDPI();	
			
		string strLT;
		strLT.Format("Image.ShowOptions=0;Image.FileName$=%s;", strFileName);
	
	
		int 	nBitsPerPixel = GetColorDepth();
		int 	nCompression = Getcompression();
		bool	bGray = IsGraySacle();
		
		/// Hong 08/10/09 QA90-13280 SHOULD_REMOEV_PROJECT_TREE_AFTER_USED
		string			strLTPDFMultiPgSetting("LTTreePDFMultiPg");
		/// end SHOULD_REMOEV_PROJECT_TREE_AFTER_USED
		string	str;
		if( is_image_file_type_ext(strExt, IFT_VECTOR) )
		{
			/// Hong 04/17/09 QA80-13280 SUPPORT_EXPORT_MULTI_PAGES_PDF
			//str.Format("imgexp=Image.Export.PageDPI(%s, %d, %d, %d, %d);", strExt, nDPI, nBitsPerPixel, nCompression, bGray);
			if ( !bMultiPgPDF )
				str.Format("imgexp=Image.Export.PageDPI(%s, %d, %d, %d, %d);", strExt, nDPI, nBitsPerPixel, nCompression, bGray);
			else
			{
				TreeNode 		trPDF = getPDFOptions(trImageOptions);
				ASSERT(trPDF);
				TreeNode 		trPDFAdditional = get_additional_options(trImageOptions, "PDF");
				ASSERT(trPDFAdditional);
				/// Hong 09/18/09 QA80-13280-P11 FIX_MARGIN_SETTING_NOT_USED_IN_EXP_PDF_PAGE
				TreeNode		trPrintOpts = GetPrintOptions();
				if ( trPrintOpts)
				{
					if (  0 != trPrintOpts.UseOwn.nVal  )
					{
						Worksheet	wks = pg.Layers(nLayerIndex);
						_apply_wks_print_opts_to_tree(wks, trPrintOpts);
					}
					_construct_dimension_tree(trPDFAdditional, trPrintOpts);
				}
				/// end FIX_MARGIN_SETTING_NOT_USED_IN_EXP_PDF_PAGE
				/// Hong 08/10/09 QA90-13280 SHOULD_REMOEV_PROJECT_TREE_AFTER_USED
				//string			strLTPDFMultiPgSetting("LTTreePDFMultiPg");
				/// end SHOULD_REMOEV_PROJECT_TREE_AFTER_USED
				Project.AddTree(strLTPDFMultiPgSetting, trPDFAdditional);
				str.Format("imgexp=Image.Export.PageDPI(%s, %d, %d, %d, %d, mpwks, %s);", strExt, nDPI, nBitsPerPixel, nCompression, bGray, strLTPDFMultiPgSetting);
			}
			/// end SUPPORT_EXPORT_MULTI_PAGES_PDF
		}
		else if( is_image_file_type_ext(strExt, IFT_RASTER) )
		{		
			double 	dWidthOnPixel, dHeightOnPixel;
			ConvertSize(pg, dWidthOnPixel, UNIT_PIXEL, dWidth, nUnits, &nDPI, true);
			ConvertSize(pg, dHeightOnPixel, UNIT_PIXEL, dHeight, nUnits, &nDPI, false);
			
			str.Format("imgexp=Image.Export.PagePixel(%s, %f, %f, %d, %d, %d);", strExt, dWidthOnPixel, dHeightOnPixel, nBitsPerPixel, nCompression, bGray);	
		}
		else
		{
			strErrMsg = "image type";
			return XFERR_INVALID_MSG;
		}
	
		/// Hong 06/17/09 QA80-13280 EXPORT_MULTI_PAGES_PDF_MORE_PRINT_OPTIONS
	#ifdef		SUPPORT_EXPORT_MULTI_PAGES_PDF
		Tree		trOriginPrintOptions;
		Worksheet	wks = pg.Layers(nLayerIndex);
		if ( bMultiPgPDF )
		{
			/// Hong 07/21/09 QA80-13280-P4 WKS_EXPORT_MULTIPAGE_PDF_PAGE_BREAKS
			/*
			FUNC_APPLY_PRINT_OPTIONS pfn = Project.FindFunction("apply_print_options", STR_PRINT_FUNCTION_FILE);
			TreeNode			trPrintOpts = trImageOptions.Print;
			Tree				trFullPrintOptsTree;
			if ( wks && trPrintOpts && pfn && _get_print_opts(trFullPrintOptsTree) )
			{
				wks.GetPrintOptions(trOriginPrintOptions);
				trFullPrintOptsTree.FirstNode.Replace(trPrintOpts, TRUE, TRUE, TRUE);
				pfn(trFullPrintOptsTree, wks);
			}
			else
				ASSERT(FALSE);
			*/
			/// Hong 07/22/09 QA80-13935 MOVE_PRINT_OPTION_TO_HIGHER_LEVEL
			//TreeNode 		trPDFAdditional = get_additional_options(trImageOptions, "PDF");
			//TreeNode		trPrintOpts = trPDFAdditional.Print;
			//if ( trPrintOpts && 1 == trPrintOpts.Use )
			TreeNode		trPrintOpts = GetPrintOptions();
			if ( trPrintOpts && 0 == trPrintOpts.UseOwn.nVal )
			/// end MOVE_PRINT_OPTION_TO_HIGHER_LEVEL
			{
				FUNC_APPLY_PRINT_OPTIONS pfn = Project.FindFunction("apply_print_options", STR_PRINT_FUNCTION_FILE);
				if ( pfn && wks )
					pfn(trPrintOpts, wks);
			}
			/// end WKS_EXPORT_MULTIPAGE_PDF_PAGE_BREAKS
		}
	#endif		//SUPPORT_EXPORT_MULTI_PAGES_PDF
		/// end EXPORT_MULTI_PAGES_PDF_MORE_PRINT_OPTIONS
		strLT += str;
		double 	dImgExpErr;
		bool	bLTRet;
		if(nLayerIndex < 0)
		{
			bLTRet = pg.LT_execute(strLT);			
			strErrMsg = " " + pg.GetName();
		}
		else
		{
			Layer lay = pg.Layers(nLayerIndex);
			bLTRet = lay.LT_execute(strLT);
			strErrMsg = " [" + pg.GetName() + "]" + lay.GetName();
		}
		/// Hong 08/10/09 QA90-13280 SHOULD_REMOEV_PROJECT_TREE_AFTER_USED
		if ( bMultiPgPDF )
			Project.DeleteTree(strLTPDFMultiPgSetting);
		/// end SHOULD_REMOEV_PROJECT_TREE_AFTER_USED
		
		/// Hong 07/21/09 QA80-13280-P4 WKS_EXPORT_MULTIPAGE_PDF_PAGE_BREAKS
		/*
		/// Hong 06/17/09 QA80-13280 EXPORT_MULTI_PAGES_PDF_MORE_PRINT_OPTIONS
	#ifdef		SUPPORT_EXPORT_MULTI_PAGES_PDF
		if ( bMultiPgPDF )
		{
			if ( trOriginPrintOptions.FirstNode )
				wks.SetPrintOptions(trOriginPrintOptions);
		}
	#endif		//SUPPORT_EXPORT_MULTI_PAGES_PDF
		/// end EXPORT_MULTI_PAGES_PDF_MORE_PRINT_OPTIONS
		*/
		/// end WKS_EXPORT_MULTIPAGE_PDF_PAGE_BREAKS
		
		if( bLTRet && LT_get_var("imgexp", &dImgExpErr) )
		{
			strErrMsg.Empty();
			return (int)dImgExpErr;
		}
		
		return CER_EXPORT_PAGE_FAIL;//-1;
	}
	
	bool updatePicturePreview(PictureControl& pict, Page& pg, int nLayerIndex, const string& strExt, string& strErrMsg, bool bSystem, bool bSource, bool bUpdateRatio = false)
	{
		TreeNode tr, tr1, tr2;
		tr = GetPageOptions();
		tr1 = GetPageSize();
		tr2 = GetImageOptions();
		
		double		dWidthOnPixel, dHeightOnPixel;
		tr1.PixelSize.GetAttribute(STR_PIXEL_WIDTH, dWidthOnPixel);
		tr1.PixelSize.GetAttribute(STR_PIXEL_HEIGHT, dHeightOnPixel);
		if( dWidthOnPixel * dHeightOnPixel > MAX_PIXEL && tr1.PixelSize.Show ) 
		{
			strErrMsg = CER_LARGE_PIXEL_NOT_PREVIEW;
			return true;
		}
		
		bool bRet = false;
		char		szTempPath[MAXFULLPATH];
		GetTempPath(MAXFULLPATH, szTempPath);
		string strTempFile = szTempPath;
	
		if( is_image_file_type_ext(strExt, IFT_VECTOR) )
		{
			strTempFile += "__OriginEMFPreview.EMF";
			string strErrMsg;
			if( 0 == exportPage(pg, nLayerIndex, strTempFile, "EMF", strErrMsg, strExt, true, bSystem, bSource, bUpdateRatio) )
			{
				HENHMETAFILE hEMF = load_enhanced_metafile(strTempFile);
				bRet = pict.SetEnhMetaFile(hEMF);
				pict.DrawMode = PCDM_STRETCH_KEEP_ASPECT_RATIO;			
			}
		}
		else
		{
			strTempFile += "__OriginRasterPreview." + strExt;
			string strErrMsg;
			///Kyle 07/28/2010 ORG-666-S1 USE_FULL_RESOLUTION_TO_EXPORT_WATERFALL_GRAPH, bIsPreview shoule be true here
			//if( 0 == exportPage(pg, nLayerIndex, strTempFile, strExt, strErrMsg, NULL, false, bSystem, bSource, bUpdateRatio) )
			if( 0 == exportPage(pg, nLayerIndex, strTempFile, strExt, strErrMsg, NULL, true, bSystem, bSource, bUpdateRatio) )
			///End USE_FULL_RESOLUTION_TO_EXPORT_WATERFALL_GRAPH
			{
				FILEINFO fi;
				int nErr;
				LPVOID pLbmp = image_import(strTempFile, &fi, &nErr);
				if(NULL != pLbmp)
				{
					pict.SetLeadBitmap(pLbmp, TRUE); // TRUE = take ownership and delete when done
					pict.DrawMode = PCDM_NO_STRETCH;
				}			
			}
		}
		pict.SetBackgroundColor(SYSCOLOR_WHITE);
		pict.SetBorderColor(SYSCOLOR_LTGRAY);
		
		DeleteFile(strTempFile);
		return bRet;
	}
	
	bool updateNonePicturePreview(GraphPage& gp, PictureControl& pict, int nErr = TEMPLATE_NONE_PREVIEW_HINTS)
	{
		bool	bTempCreated = false;
		if ( !gp )
		{
			bTempCreated = true;
			gp.Create(NULL, CREATE_SET_MISSING_IN_MANAGER);
		}
		
		page_load(gp, STR_NONE_PREVIEW_TEMPLATE);
		load_text_for_nonepreview_graphpage(gp, TEMPLATE_NONE_PREVIEW_CONTENT, nErr);
		_page_disable_click(gp);
		
		char		szTempPath[MAXFULLPATH];
		GetTempPath(MAXFULLPATH, szTempPath);
		string strTempFile = szTempPath;
	
		strTempFile += "__OriginEMFNoPreview.EMF";	
		
		int bRet = false;
		if ( export_page(gp, strTempFile, "EMF") )
		{
			HENHMETAFILE hEMF = load_enhanced_metafile(strTempFile);
			bRet = pict.SetEnhMetaFile(hEMF);
			pict.DrawMode = PCDM_STRETCH_KEEP_ASPECT_RATIO;	
		}		
		
		pict.SetBackgroundColor(SYSCOLOR_WHITE);
		pict.SetBorderColor(SYSCOLOR_LTGRAY);
		
		DeleteFile(strTempFile);
		
		if ( bTempCreated )
			gp.Destroy();
		
		return bRet;
	}
	
	///---Sim 12-23-2008 QA80-12836 SUPPORT_FILE_BROWSER_BUTTON
	void updateFilenameAttribute(TreeNode& trGetN)
	{
		string strPath = trGetN.path.strVal;
		//strPath = cvt_predefined_path_to_real_path(strPath);
		
		//string strType, strExt;
		//getImageFileTypeDescripAndExt(strType, strExt);
		string strFileFilter = get_open_dlg_file_filter(GetImageTypeDescription(), GetImageTypeExtension());
		
		tree_set_file_browse_combo_more_attrib(trGetN.filename, strPath, strFileFilter);		
	}
	void updatePathFromFileBrowserAttribute(TreeNode& trGetN)
	{
		string strPath;
		if ( trGetN.filename.GetAttribute(STR_BROWSER_COMBO_FILE_PATH, strPath) )
		{
			trGetN.path.strVal = strPath;
		}
	}
	///---END QA80-12836 SUPPORT_FILE_BROWSER_BUTTON

protected:
	CGraphicalExportPage* m_pExpPage;
		
	bool		m_bSystemPageOption;
	TreeNode	m_trPageOptions;
	TreeNode	m_trPageSize;
	TreeNode	m_trPrintOpts; /// Hong 07/22/09 QA80-13935 MOVE_PRINT_OPTION_TO_HIGHER_LEVEL
	
	StringArray m_saTargets;
	
	vector<DWORD> vSaveRestoreObj;
	/// Hong 11/01/07 v8.0738 CLEAN_ERROR_MSG_MACHNISM
	bool 	m_bValidPath;
	bool 	m_bValidFileName;
 	bool 	m_bValidWidth;
 	bool 	m_bValidSourcePage;
 	bool 	m_bValidPreview;
 	bool 	m_bNoDuplicateFileName; ///---Sim 08-17-2007 CHECK_DUPLICATE_FILE_NAMES
 	bool 	m_bNoHierarchySheet;

 	string 	m_strErrWidth;
 	string 	m_strErrPath;
 	string 	m_strErrPreview; 
 	/// end CLEAN_ERROR_MSG_MACHNISM
};


//////////////////////////////////////////////////////////////////
///  CGraphicalExportGraphEx
//////////////////////////////////////////////////////////////////
class CGraphicalExportGraphEx : public CGraphicalExportPageEx
{
public:
	CGraphicalExportGraphEx()
	{
		m_pExpPage = new CGraphicalExportGraph;
	}
	~CGraphicalExportGraphEx()
	{
		if ( m_pExpPage )
			delete m_pExpPage;
	}
	
	virtual void 	SetTarget(StringArray& saTargets)
	{
		m_saTargets = saTargets;
	}
	
	void		SetPageTheme(LPCSTR lpcszPageTheme)
	{
		m_strPageTheme = lpcszPageTheme;
	}
	
protected:
	///Kyle 01/28/2010 QA80-15041 WANT_ENABLE_GRAPH_CURRENT_SPEED_MODE_FOR_EXPORT
	// virtual
	bool	GetSaveRestoreObj(SaveRestorePageSettings** ppSR, Page& pg = NULL, int nLayerIndex = -1)
	{
		if( EXIST_PLOT == GetPageType() )
		{
			GraphPage gp(pg);
			*ppSR = new SaveRestoreGraphPageSettings(gp);
		}
		else
		{
			CGraphicalExportPageEx::GetSaveRestoreObj(ppSR, pg, nLayerIndex);
		}

		return true;
	}
	///End WANT_ENABLE_GRAPH_CURRENT_SPEED_MODE_FOR_EXPORT

	virtual bool 	ApplyPageSettings(Page& pg = NULL, int nLayerIndex = -1)
	{
		CGraphicalExportPageEx::ApplyPageSettings(pg, nLayerIndex);

		GraphPage gp(pg);
		if ( !gp )
			return false;
		
		if ( m_strPageTheme.IsEmpty() )
			//m_strPageTheme = "<Original>";
			m_strPageTheme = STR_DEFAULT_THEME; /// Hong 10/19/07 v8.0728 IMPROVE_AND_CENTRALIZE_CODE
			
		///Kyle 07/30/2010 ORG-674-P1 EXPORT_LAYOUT_SHOULD_NOT_APPLY_THE_THEME_FOR_GRAPH
		//_gui_apply_theme(m_strPageTheme, gp);
		if( EXIST_PLOT == GetPageType() )
			_gui_apply_theme(m_strPageTheme, gp);
		///End EXPORT_LAYOUT_SHOULD_NOT_APPLY_THE_THEME_FOR_GRAPH
		
		///Kyle 01/28/2010 QA80-15041 WANT_ENABLE_GRAPH_CURRENT_SPEED_MODE_FOR_EXPORT
		if( EXIST_PLOT == GetPageType() )
		{
			ASSERT(m_trPageOptions.SpeedMode);
			if( SPEED_MODE_AUTO != m_trPageOptions.SpeedMode.nVal )
			{
				bool bUseSpeedMode = (SPEED_MODE_ON == m_trPageOptions.SpeedMode.nVal);
				gp.SetUseSpeedModeForExport(bUseSpeedMode);
			}
		}
		///End WANT_ENABLE_GRAPH_CURRENT_SPEED_MODE_FOR_EXPORT
		
		return true;
	}
	
	virtual void	SetGetNOptions(const TreeNode& trGetN)
	{
		if ( trGetN.theme )
			SetPageTheme(trGetN.theme.strVal);
		SetPageOptions(trGetN.tr);
		SetPageSize(trGetN.tr1);
		SetImageOptions(trGetN.tr2);
	}
	
	virtual void 	AfterChangedPageSelectionOption(TreeNode& trGetN, string* pstrErrMsg = NULL, bool* pbOK = NULL)
	{
		string	strPages = get_page_short_name_from_page_list(trGetN.pages.strVal, STR_PAGE_LIST_SEPARATOR, -1); //-1 means all pages
		string	strRemove;
		trGetN.pages.GetAttribute(STR_EXCLUDE_PAGE_ATTRIB, strRemove);	

		int nPageType = GetPageType();
		///---put assumption into couple static function
		//int 	nOption = trGetN.export.nVal;
		//if ( bLayout && nOption >= OPTION_ALL_EMBEDDED_IN_ACTIVE_FOLDER ) //for layout, no embedded item
		//	nOption++;
		int nOption = _get_export_option_without_embeded_if_layout(trGetN.export, nPageType == EXIST_LAYOUT );
		///---
		
		vector<string> 	vsPages;
		///---Sim 07-14-2009 QA81-13935-P1 SUPPORT_EXPORT_ALL_SHORTCUT_PAGE_IN_FOLDER
#ifndef __SUPPORT_EXPORT_ALL_SHORTCUT_PAGE_IN_FOLDER__
		get_folder_pages_name(vsPages, nOption, 0, strPages, strRemove, nPageType, true);
#else
		get_folder_pages_name(vsPages, nOption, 0, strPages, strRemove, nPageType, true, true);
#endif ///__SUPPORT_EXPORT_ALL_SHORTCUT_PAGE_IN_FOLDER__
		///---END QA81-13935-P1 SUPPORT_EXPORT_ALL_SHORTCUT_PAGE_IN_FOLDER
		
		strPages.SetTokens(vsPages, STR_PAGE_LIST_SEPARATOR);
		trGetN.pages.strVal = strPages;	
		trGetN.pages.Enable = OPTION_SPECIFIED == nOption? ENABLE : ENABLE_READONLY_SCROLL;	///Jasmine 07/15/08 QA80-11845 ENABLE_READONLY_SCROLL_FOR_MULTI_EDIT
		
		bool bPageShow = true;
		if ( OPTION_ACTIVE_PAGE == nOption )
		{
			Page pg = Project.Pages();
			if(pg.IsValid() && (EXIST_PLOT == pg.GetType() || EXIST_LAYOUT == pg.GetType()))
				bPageShow = false;
		}
		trGetN.pages.Show = bPageShow;
	}
	
	///Kyle 08/23/2010 ORG-338-S1 SHOW_PAGE_ORIGINAL_SIZE_AS_HINT
	bool	GetOriginalPageSize(Page& pg, double& dWidth, double& dHeight, int* pUnits = NULL)
	{
		return _get_page_size(pg, dWidth, dHeight, pUnits);
	}
	///End SHOW_PAGE_ORIGINAL_SIZE_AS_HINT
	
	// virtual
	bool getSourcePage(LPCSTR lpcszPages, PageBase& pg, int* pnLayerIndex = NULL)
	{
		//find the current graph page as preivew
		Page			page;
		string			strActivePage;
		if( Project.ActiveLayer() )
		{
			page = Project.ActiveLayer().GetPage();
			strActivePage = get_page_short_long_name(page);
		}		
		
		vector<string>	vsPages;
		string	strPageList(lpcszPages);
		///---Sim 07-13-2009 QA81-13923 FIX_EXP_GRAPH_FAILED_WHEN_LONG_NAME_CONTAIN_ONLY_ONE_DOUBLE_QUOTATION_MARK
#ifdef __FIX_EXP_GRAPH_FAILED_WHEN_LONG_NAME_CONTAIN_ONLY_ONE_DOUBLE_QUOTATION_MARK__
		okutil_get_tokens(strPageList, &vsPages, STR_PAGE_LIST_SEPARATOR, NULL);
#else
		///---END QA81-13923 FIX_EXP_GRAPH_FAILED_WHEN_LONG_NAME_CONTAIN_ONLY_ONE_DOUBLE_QUOTATION_MARK
		strPageList.GetTokens(vsPages, STR_PAGE_LIST_SEPARATOR);
#endif ///---Sim 07-13-2009 QA81-13923 FIX_EXP_GRAPH_FAILED_WHEN_LONG_NAME_CONTAIN_ONLY_ONE_DOUBLE_QUOTATION_MARK
		
		int 			index;
		if( !is_in_list(strActivePage, vsPages, false, &index) )
			index = 0;//if current page is not in Page List, then the first page in List as preivew
		
		string	strCurrentPage = get_page_short_name_from_page_list(lpcszPages, STR_PAGE_LIST_SEPARATOR, index);
		
		GraphPageBase gpTemp;
		bool	bRet = okxf_resolve_string_get_origin_object(strCurrentPage, &gpTemp);
		if(gpTemp)
		{
			pg = gpTemp;
		}
		
		return bRet;
	}
	
	// virtual
	bool getPreviewPage(const TreeNode& trGetN, PageBase& pg, bool& bTempCreated, int* pnLayerIndex = NULL)
	{
		GraphPage gp(pg);
		if ( !pg )
		{
			bTempCreated = true;
			//--------- CPY 5/6/08 QA70-11514 LAYOUT_PAGE_EXPORT_NOT_USING_WRONG_TEMP_PAGE_TYPE
			//gp.Create(NULL, CREATE_SET_MISSING_IN_MANAGER);
			ASSERT(!gp);

			/// YuI 05/20/08 QA70-11570 PAGE_EXPORT_FAILS_IF_LONG_NAME_PRESENT
			// can not use trGetN.pages.strVal directly
			// this may be multiline list with combination of short/long name
			//	gp = clone_graph(trGetN.pages.strVal);
			
			gp = clone_graph(get_page_short_name_from_page_list(trGetN.pages.strVal));
			/// end PAGE_EXPORT_FAILS_IF_LONG_NAME_PRESENT
			
			//---------
		}
		///------ Folger 09/25/2010 ORG-1123-P1 INDEX_OF_ANNOTATION_LOST_IN_EXPORT_GRAPH
		/// clone_graph and pageClone both call page_clone to do duplication, the only difference is that clone_graph will new page with default template if destination page not valid
		else
		///------ End INDEX_OF_ANNOTATION_LOST_IN_EXPORT_GRAPH
		{
			pageClone(trGetN.pages.strVal, gp); //get source graph and make clone to pgTemp
		}
		///Kyle 07/30/2010 ORG-674-P1 EXPORT_LAYOUT_SHOULD_NOT_APPLY_THE_THEME_FOR_GRAPH
		//_gui_apply_theme(trGetN.theme.strVal, gp);
		if( EXIST_PLOT == GetPageType() )
			_gui_apply_theme(trGetN.theme.strVal, gp);
		///End EXPORT_LAYOUT_SHOULD_NOT_APPLY_THE_THEME_FOR_GRAPH
		
		pg = gp;
		
		return true;				
	}
	
protected:
	string		m_strPageTheme;	
};



//////////////////////////////////////////////////////////////////
///  CGraphicalExportWksEx
//////////////////////////////////////////////////////////////////
enum{
	AREA_VISIBLE = 0,
	AREA_WHOLE,
	AREA_SELECTION,
};

class CGraphicalExportWksEx : public CGraphicalExportPageEx
{
public:
	CGraphicalExportWksEx()
	{
		m_pExpPage = new CGraphicalExportWks;
	}
	~CGraphicalExportWksEx()
	{
		if ( m_pExpPage )
			delete m_pExpPage;
	}
	
	virtual void 	SetTarget(StringArray& saTargets)
	{
		// not implemented yet		
	}
	
protected:
	virtual bool 	ApplyPageSettings(Page& pg = NULL, int nLayerIndex = -1)
	{
		CGraphicalExportPageEx::ApplyPageSettings(pg, nLayerIndex);

		///Kyle 08/23/2010 ORG-338-S1 SHOW_PAGE_ORIGINAL_SIZE_AS_HINT
		/*
		if ( !pg || nLayerIndex >= pg.Layers.Count() )
			return false;
		Worksheet wks =	pg.Layers(nLayerIndex);
		if ( !wks )
			return false;
		
		ORANGE rng;
		
		TreeNode trArea = m_trPageOptions.Area;
		if ( !trArea )
			return false;
		
		bool bClearPrintArea = false;
		switch ( trArea.nVal )
		{
		case AREA_VISIBLE:
			bClearPrintArea = true;
			break;
		case AREA_WHOLE:
			rng.r1 = 0;
			rng.c1 = 0;
			rng.r2 = wks.GetNumRows() - 1;
			rng.c2 = wks.GetNumCols() - 1;
			
			break;
		case AREA_SELECTION:
			int nR1, nC1, nR2, nC2;
			int nType = wks.GetSelectedRange(nR1, nC1, nR2, nC2);
			if ( WKS_SEL_NONE != nType )
			{
				if ( nR2 < 0 )
					nR2 = wks.GetNumRows() - 1;
				if ( nC2 < 0 )
					nC2 = wks.GetNumCols() - 1;
				
				rng.r1 = nR1;
				rng.c1 = nC1;
				rng.r2 = nR2;
				rng.c2 = nC2;
			}
			else
			{
				rng.r1 = 0;
				rng.c1 = 0;
				rng.r2 = wks.GetNumRows() - 1;
				rng.c2 = wks.GetNumCols() - 1;
			}
			
			break;
		}
			
		if ( bClearPrintArea )
			wks.SetPrintArea(NULL);
		else
			wks.SetPrintArea(&rng);
		
		return true;
		*/
		TreeNode trArea = m_trPageOptions.Area;
		if ( !trArea )
			return false;
		return SetPageAreaSetting(pg, trArea.nVal, nLayerIndex);
		///End SHOW_PAGE_ORIGINAL_SIZE_AS_HINT
	}
	
	///Kyle 08/23/2010 ORG-338-S1 SHOW_PAGE_ORIGINAL_SIZE_AS_HINT
	bool		SetPageAreaSetting(Page& pg, int nArea, int nLayerIndex = -1)
	{
		if ( !pg || nLayerIndex >= pg.Layers.Count() )
			return false;

		Worksheet wks =	pg.Layers(nLayerIndex);
		if ( !wks )
			return false;

		ORANGE rng;
		bool bClearPrintArea = false;
		switch( nArea )
		{
		case AREA_VISIBLE:
			bClearPrintArea = true;
			break;

		case AREA_WHOLE:
			rng.r1 = 0;
			rng.c1 = 0;
			rng.r2 = wks.GetNumRows() - 1;
			rng.c2 = wks.GetNumCols() - 1;
			break;

		case AREA_SELECTION:
			int nR1, nC1, nR2, nC2;
			int nType = wks.GetSelectedRange(nR1, nC1, nR2, nC2);
			if ( WKS_SEL_NONE != nType )
			{
				if ( nR2 < 0 )
					nR2 = wks.GetNumRows() - 1;
				if ( nC2 < 0 )
					nC2 = wks.GetNumCols() - 1;
				
				rng.r1 = nR1;
				rng.c1 = nC1;
				rng.r2 = nR2;
				rng.c2 = nC2;
			}
			else
			{
				rng.r1 = 0;
				rng.c1 = 0;
				rng.r2 = wks.GetNumRows() - 1;
				rng.c2 = wks.GetNumCols() - 1;
			}
			break;

		default:
			ASSERT(0);
			return false;
		}

		if ( bClearPrintArea )
			wks.SetPrintArea(NULL);
		else
			wks.SetPrintArea(&rng);
		
		return true;
	}

	virtual bool	GetOriginalPageSize(Page& pg, double& dWidth, double& dHeight, int* pUnits = NULL)
	{
		if( !pg )
			return false;

		BackupPageSettings(pg);
		//ApplyPageSettings(pg);
		OriginSettings os;
		os.SetValue("CopyPage.ClipBorderw", 0);
		SetPageAreaSetting(pg, AREA_WHOLE);
		
		if(pUnits)
			*pUnits = UNIT_INCH;

		RECT 	rect;
		_compute_page_export_inch(pg, 1.0, dWidth, true, &rect); // just get rect
		dHeight = round(RECT_HEIGHT(rect) * dWidth / RECT_WIDTH(rect), DEFAULT_DECIMAL_PLACES);

		RestorePageSettings(pg);
		return true;
	}
	///End SHOW_PAGE_ORIGINAL_SIZE_AS_HINT
	
	virtual bool	GetSaveRestoreObj(SaveRestorePageSettings** ppSR, Page& pg = NULL, int nLayerIndex = -1)
	{
		Worksheet wks;
		if ( pg && nLayerIndex < pg.Layers.Count() ) 
			wks =	pg.Layers(nLayerIndex);
		
		if ( wks )
		{
			*ppSR = new SaveRestoreWksPageSettings(wks);
		}
		else
		{
			*ppSR = new SaveRestoreWksPageSettings();
		}
		
		return true;
	}
	
	virtual bool	RemoveSaveRestoreObj(SaveRestorePageSettings* pSR, Page& pg = NULL, int nLayerIndex = -1)
	{
		SaveRestoreWksPageSettings* pSRWks = pSR;
		if ( pSRWks )
			delete pSRWks;
		
		return true;
	}

	virtual void	SetGetNOptions(const TreeNode& trGetN)
	{
		SetPageOptions(trGetN.tr);
		SetPageSize(trGetN.tr1);
		SetImageOptions(trGetN.tr2);
		/// Hong 07/22/09 QA80-13935 MOVE_PRINT_OPTION_TO_HIGHER_LEVEL
		SetPrintOptions(trGetN.tr3);
		/// end MOVE_PRINT_OPTION_TO_HIGHER_LEVEL
	}
	
	virtual void 	AfterChangedPageSelectionOption(TreeNode& trGetN, string* pstrErrMsg = NULL, bool* pbOK = NULL)
	{
		_refresh_sheets(trGetN, pstrErrMsg, pbOK);
	}
	
	// virtual
	bool getSourcePage(LPCSTR lpcszPages, PageBase& pg, int* pnLayerIndex = NULL)
	{
		//find the current worksheet layer as preivew
		string			strActiveLayer;
		Worksheet wks = Project.ActiveLayer();
		if( wks )
		{
			wks.GetRangeString(strActiveLayer); //construct worksheet name like the format in Worksheet List
			strActiveLayer.Remove('!');
		}		
		
		vector<string>	vsWks;
		string	strWksList(lpcszPages);
		strWksList.GetTokens(vsWks, STR_PAGE_LIST_SEPARATOR);
		
		int 			index;
		if( !is_in_list(strActiveLayer, vsWks, false, &index) )
			index = 0;//if current worksheet is not in worksheet List, then the first worksheet in List as preivew
		
		string	strCurrentWorksheet = get_page_short_name_from_page_list(lpcszPages, STR_PAGE_LIST_SEPARATOR, index);
		
		int bRet = okxf_resolve_string_get_origin_object(strCurrentWorksheet, &wks);
		if(wks)
		{
			pg = wks.GetPage();
			if(pnLayerIndex)
				*pnLayerIndex = wks.GetIndex();
		}
		
		return bRet;
	}
	
	// virtual
	bool getPreviewPage(const TreeNode& trGetN, PageBase& pg, bool& bTempCreated, int* pnLayerIndex = NULL)
	{
		bTempCreated = false;
		return getSourcePage(trGetN.pages.strVal, pg, pnLayerIndex);
	}
	
	/// Hong 07/21/09 QA80-13280-P4 WKS_EXPORT_MULTIPAGE_PDF_PAGE_BREAKS
#ifdef		SUPPORT_EXPORT_MULTI_PAGES_PDF
	//virtual 
	bool checkUpdatePrintOpts(TreeNode& trGetN)
	{
		WorksheetPage		wkp;
		int					nIndex;
		if ( !getSourcePage(trGetN.pages.strVal, wkp, &nIndex) )
			return false;
		Worksheet			wks = wkp.Layers(nIndex);
		/// Hong 07/22/09 QA80-13935 MOVE_PRINT_OPTION_TO_HIGHER_LEVEL
		/*
		TreeNode 			trPDFAdditional = get_additional_options(GetImageOptions(), "PDF");
		if ( !trPDFAdditional || !trPDFAdditional.Print )
			return false;
		TreeNode			trPrint = trPDFAdditional.Print;
		if ( 1 == trPrint.Use )
			return true;
		*/
		TreeNode			trPrint = trGetN.tr3;
		if ( 0 == trPrint.UseOwn.nVal )
			return true;
		/// end MOVE_PRINT_OPTION_TO_HIGHER_LEVEL
		return _apply_wks_print_opts_to_tree(wks, trPrint);
	}
#endif		//SUPPORT_EXPORT_MULTI_PAGES_PDF
	/// end WKS_EXPORT_MULTIPAGE_PDF_PAGE_BREAKS
	
	/// Hong 10/13/09 QA80-13280-S3 BETTER_PREDEFINE_FILE_NAME_LABEL_FOR_WKS
	//virtual 
	string getPredefinedFileName() { return _L("Wks##"); }
	/// end BETTER_PREDEFINE_FILE_NAME_LABEL_FOR_WKS
};


// begin -- move from themeApply2w.oxf
#define PAGE_OPTION_OFFSET			0

enum{
	export_CurSheet,
	export_SheetsInBook,
	export_SheetsInFld,
	export_SheetInFldRe,
	export_SheetsInProject,
	export_Specified,
};
static int s_nOptionMap[] = {
	-1,
	OPTION_ACTIVE_PAGE,
	OPTION_ALL_IN_ACTIVE_FOLDER,
	OPTION_ALL_RECURSIVE_IN_ACTIVE_FOLDER,
	OPTION_ALL_IN_OPJ,
	-1
};

static bool _make_sheet_list_from_pages(vector<string>&vsSheets, const vector<string> &vsPages)
{
	string strTmp;
	vsSheets.SetSize(0);
	int nSize = vsPages.GetSize();
	//vector<string> vsSheets;
	for (int ii=0; ii<nSize; ii++)
	{
		Page pg(vsPages[ii]);
		foreach(Layer lay in pg.Layers)
		{
			Worksheet wks(lay);
			if (wks)
			{
				wks.GetRangeString(strTmp);
				vsSheets.Add(strTmp);
			}
		}
	}
	//strTmp.SetTokens(vsSheets, STR_PAGE_LIST_SEPARATOR);
	//return strTmp;
	return true;
}
static bool _remove_hierarchy_sheet(vector<string>&vsSheets, string* pstrErrMsg = NULL, bool* pbOK = NULL)
{
	int nSize = vsSheets.GetSize();
	for ( int ii = nSize - 1; ii >= 0; ii-- )
	{
		Worksheet wks(vsSheets[ii]);
		//if (wks.GetSystemParam(0) & WP_SHEET_HIERARCHY)
		if ( !wks.IsValid() || (wks.GetSystemParam(0) & WP_SHEET_HIERARCHY) ) /// Hong 02/04/08 b8.0799c FIX_RUNTIME_ERROR_WHEN_SEPCIFY_INVALID_WORKSHEET_RANGE_NAME
		{
			vsSheets.RemoveAt(ii);
			if ( pstrErrMsg )
				*pstrErrMsg = EXPWARN_WKS_NOT_SUPPORT_RESULT_SHEET;
		}
	}
	
	return true;
}

static void _refresh_sheets(TreeNode &trGetN, string* pstrErrMsg = NULL, bool* pbOK = NULL)
{
	vector<string> vsSheets;
	if (trGetN.export.nVal == export_CurSheet)
	{
		Worksheet wks(Project.ActiveLayer());
		if (wks)
		{
			string strTmp;
			wks.GetRangeString(strTmp);
			//trGetN.pages.strVal = strTmp;
			vsSheets.Add(strTmp);
		}
	}
	else if (trGetN.export.nVal != export_Specified)
	{
		vector<string> vsPages;
		int nWkss = get_folder_pages_name(vsPages, s_nOptionMap[trGetN.export.nVal], PAGE_OPTION_OFFSET, NULL, NULL, EXIST_WKS);
		//trGetN.pages.strVal = _make_sheet_string_from_pages(vsPages);
		_make_sheet_list_from_pages(vsSheets, vsPages);
	}
	else // specified
	{
		string strTmp = trGetN.pages.strVal;
		strTmp.GetTokens(vsSheets, STR_PAGE_LIST_SEPARATOR);
	}
	
	_remove_hierarchy_sheet(vsSheets, pstrErrMsg, pbOK);
	
	string strSheets;
	strSheets.SetTokens(vsSheets, STR_PAGE_LIST_SEPARATOR);
	//trGetN.pages.strVal.Remove('!');
	strSheets.Remove('!');
	trGetN.pages.strVal = strSheets;
	trGetN.pages.Enable = trGetN.export.nVal == export_Specified? ENABLE : ENABLE_READONLY_SCROLL;	///Jasmine 07/15/08 QA80-11845 ENABLE_READONLY_SCROLL_FOR_MULTI_EDIT

	///---Sim 09-21-2009 FIX_OPEN_EXP_WKS_RUNTIME_ERROR_IF_NO_WKS_ACTIVE
	// temp code
	Worksheet wks(Project.ActiveLayer());
	// stop open dialog if active sheet is no worksheet
	if ( !wks )
	{
		if ( pstrErrMsg )
			*pstrErrMsg = XFERR_NO_ACTIVE_WKSPG;
		if ( pbOK )
			*pbOK = false;
	}
	// stop open dialog if active sheet is report sheet
	//if (wks.GetSystemParam(0) & WP_SHEET_HIERARCHY)
	if ( wks && (wks.GetSystemParam(0) & WP_SHEET_HIERARCHY) )
	{
		if ( pstrErrMsg )
			*pstrErrMsg = EXPWARN_WKS_NOT_SUPPORT_RESULT_SHEET;
		if ( pbOK )
			*pbOK = false;
	}
	///---END FIX_OPEN_EXP_WKS_RUNTIME_ERROR_IF_NO_WKS_ACTIVE
}
// end -- move from themeApply2w.oxf

//////////////////////////////////////////////////////////////////
///  need to optimize
//////////////////////////////////////////////////////////////////
//------ Folger 02/15/08 QA80-11007 MOVE_EXPORT_GRAPH_MAKE_TREE_TO_VC
//static bool _gui_advanced_event(TreeNode& trGetN, int nRow, int nCntrlType, Dialog& getNDlg)
//{
	////_update_advanced_options(trGetN.tr1);	///Jasmine 04/23/07 MOVE_OUT_SYSTEM_SETTING_OPTION
	//_update_advanced_options(trGetN.tr);
	//return true;	
//}
static bool _gui_advanced_event(TreeNode& myTree, int nRow, int nCol, TreeNode& trNode, DWORD dwCntrl, int nType, WndContainer& theDlg)
{
	_update_advanced_options(myTree.tr);
	return true;
}
//------

static void _remove_embeded_option_if_layout(TreeNode& trExport, bool bLayout = true)
{
	trExport.SetAttribute(STR_COMBO_ATTRIB, STR_COMBO_LAYOUT);
}

static int _get_export_option_without_embeded_if_layout(TreeNode& trExport, bool bLayout)
{
	int 	nVal = trExport.nVal;
	if ( bLayout && nVal >= OPTION_ALL_EMBEDDED_IN_ACTIVE_FOLDER ) //for layout, no embedded item
		nVal++;
	
	return nVal;
}


//----- CPY 10/27/2007 QA70-10605 OC_ACCESS_TO_PAGE_NOTSAVED_BITS should really remove this as already handled inside page_clone, as for no-preview, it should be set into template
/// Hong 10/25/07 v8.0733 DISABLE_CLICKING_ON_GRAPH_FOR_PREVIEW
static bool _page_disable_click(Page& pg)
{
	if ( !pg )
		return false;
	
	string str;
	str.Format("page.noClick=%d", 0xffff); // 0xffff to disable all options
	return pg.LT_execute(str);
}
// end DISABLE_CLICKING_ON_GRAPH_FOR_PREVIEW
//-----
//////////////////////////////////////////////////////////////////
///  
//////////////////////////////////////////////////////////////////

static bool _get_page_size(Page& pg, double& dWidth, double& dHeight, int* pUnits = NULL)
{
	if(!pg)
		return false;
	
	Tree trFormat;
	trFormat = pg.GetFormat(FPB_DIMENSION, FOB_DIMENSION);
	TreeNode trDimension = trFormat.Root.Page.Dimension;
	if(trDimension)
	{
		dWidth = trDimension.Width.dVal;
		dHeight = trDimension.Height.dVal;
		if(pUnits)
			*pUnits = trDimension.Units.nVal;
	}
	else // default size
	{
		//dWidth = 2.23;
		//dHeight = 1.55;
		dWidth = 8;
		if(pUnits)
			*pUnits = UNIT_INCH;

		RECT 	rect;
		double	dTempSize;
		_compute_page_export_inch(pg, 100/100, dTempSize, true, &rect); // just get rect

		dHeight = round(RECT_HEIGHT(rect) * dWidth / RECT_WIDTH(rect), DEFAULT_DECIMAL_PLACES);
	}
	
	return true;
}
	
static string _unit_int_to_str(int nUnit)
{
	string strUnit;
	switch(nUnit)
	{
	case UNIT_INCH:
		return _L("inch");
	case UNIT_CM:
		return _L("cm");
	case UNIT_MM:
		return _L("mm");
	case UNIT_PIXEL:
		return _L("pixel");
	case UNIT_POINT:
		return _L("point");
	}
	return "";		
}

///---not used
/*
static int _uint_str_to_int(LPCSTR lpcszUnit)
{
	string strUnit(lpcszUnit);
	if(0 == strUnit.CompareNoCase("inch") || 0 == strUnit.CompareNoCase("in"))
		return UNIT_INCH;
	if(0 == strUnit.CompareNoCase("cm"))
		return UNIT_CM;
	if(0 == strUnit.CompareNoCase("mm"))
		return UNIT_MM;	
	if(0 == strUnit.CompareNoCase("pixel"))
		return UNIT_PIXEL;
	if(0 == strUnit.CompareNoCase("point"))
		return UNIT_POINT;	
	return -1;
}
*/
///---

static int _convert_gui_unit_to_page_unit(int nGUIUnit)
{
	switch(nGUIUnit)
	{
	case GUI_UNIT_INCH:
		return UNIT_INCH;
	case GUI_UNIT_CM:
		return UNIT_CM;		
	case GUI_UNIT_PIXEL:
		return UNIT_PIXEL;
	case GUI_UNIT_RATIO:
		return UNIT_RATIO;
	}	
	ASSERT(0); /// Iris 11/17/2008 v8.0973 QA80-12597 FIX_CANNOT_EXPORT_GRAPH_IF_UNIT_IS_POINT_OR_MM
	return -1;
}

/// Iris 11/17/2008 v8.0973 QA80-12597 FIX_CANNOT_EXPORT_GRAPH_IF_UNIT_IS_POINT_OR_MM
static int _convert_page_unit_to_gui_unit(int nPageUnit)
{
	switch(nPageUnit)
	{
	case UNIT_INCH:
		return GUI_UNIT_INCH;
		
	case UNIT_CM:
		return GUI_UNIT_CM;		
		
	case UNIT_PIXEL:
		return GUI_UNIT_PIXEL;		
		
	case UNIT_RATIO:
		return GUI_UNIT_RATIO;
	}	
	return -1;	
}
///end FIX_CANNOT_EXPORT_GRAPH_IF_UNIT_IS_POINT_OR_MM

static bool _compute_page_export_ratio(const Page& pg, double *pRatio, double rRequiredWidthOrHeightInInches, BOOL bReqWidth, RECT *prRectLogical = NULL)
{
	if( !pg )
		return false;
	
	return pg.ComputeNeededExportRatio(pRatio, rRequiredWidthOrHeightInInches, bReqWidth, prRectLogical);	
}
static bool _compute_page_export_inch(const Page& pg, double dRatio, double& dValueInInches, BOOL bReqWidth, RECT *prRectLogical = NULL)
{
	if( !pg )
		return false;
	
	double dTempRatio;
	double dTempValueInch = 10;
	if ( !pg.ComputeNeededExportRatio(&dTempRatio, dTempValueInch, bReqWidth, prRectLogical) )
		return false;
	
	if ( dTempRatio <= 0 )
		return false;
	
	dTempValueInch /= dTempRatio; // get Original inches
	dValueInInches = dTempValueInch * dRatio;
	
	return true;	
}

static double _other_units_to_pixel(double dVal, int nUnits, int nDPI, double* pdPageRes = NULL)
{
	double dPixel;
	switch(nUnits)
	{
	case UNIT_CM:
		dPixel = dVal * 0.3937 * nDPI;
		break;
	case UNIT_MM:
		dPixel = dVal * 0.03937 * nDPI;
		break;
	case UNIT_POINT:
		dPixel = dVal * 0.01389 * nDPI;
		break;
	case UNIT_PIXEL:
		if(NULL != pdPageRes)
			dPixel = dVal / *pdPageRes * nDPI;
		else
			dPixel = dVal;//page solution did not changed
		break;
	case UNIT_INCH:
		dPixel = dVal * nDPI;		
		break;	
	default:
		break;
	}
	
	return dPixel;	
}
static double _pixel_to_specified_unit(double dPixel, int nUnits, int nDPI)
{
	double dVal;
	switch(nUnits)
	{
	case UNIT_CM:
		dVal = dPixel / 0.3937 / nDPI;
		break;
	case UNIT_MM:
		dVal = dPixel / 0.03937 / nDPI;
		break; 
	case UNIT_POINT:
		dVal = dPixel / 0.01389 / nDPI;
		break; 
	case UNIT_PIXEL:
		dVal = dPixel;
		break;
	case UNIT_INCH:
		dVal = dPixel / nDPI;
		break;
	default:
		break;
	}
	return dVal;	
}
static double _convert_size_to_specified_unit(double dVal, int nOldUnits, int nNewUnits, int nDPI)
{
	if(nOldUnits == nNewUnits)
		return dVal;
	
	double dPixel = _other_units_to_pixel(dVal, nOldUnits, nDPI);	
	return _pixel_to_specified_unit(dPixel, nNewUnits, nDPI);	
}

/*
static bool _init_image_options_branch(TreeNode& trOptions)
{
	if(!trOptions.IsValid())
		return false;
	
	GETN_USE(trOptions)
	GETN_STR(NoteInfo,"",_L("Note: Large DPI setting can lead to very large disk file")) GETN_INFO
	
	return true;
}
*/

static void _fix_margin_for_worksheet(TreeNode& trGetN)
{
	///---Sim 12-26-2007 QA80-10364-P10 FIX_THEME_CHANGE_BROKEN_EXPORT
	//trGetN.tr.Margin.nVal = 0; /// Hong 12/25/07 QA80-10364 FIX_THEME_CHANGE_BROKEN_EXPORT
	trGetN.tr.Margin.nVal = 0; // export worksheet only support border type
	///---END QA80-10364-P10 FIX_THEME_CHANGE_BROKEN_EXPORT
	trGetN.tr.Margin.Show = 0;
}

static void _update_advanced_options(TreeNode& trPageSettings)
{
	trPageSettings.Advanced.DPI.Enable = 0 == trPageSettings.Advanced.Resolution.nVal? true : false;
}

///------ Folger 09/14/09 QA80-14314 EXPORT_GRAPH_SUPPORT_READ_DEFAULT_IMAGE_TYPE_FROM_TOOLS_OPTION
class GetDefaultImageTypeHelper
{
public:
	GetDefaultImageTypeHelper(const vector<string>& vsTypes)
	{
		m_vsTypes = vsTypes;
		///------ Folger 10/28/09 QA81-14541 SYSTEM_DEFAULT_FILE_EXTENSION_TEMP_CHANGE_SUPPORT
		//m_strActiveGroupKey = "FILEEXT.ACTIVEGROUP";
		//m_os.GetValue(m_strActiveGroupKey, m_strActiveGroup);
		//m_os.SetValue(m_strActiveGroupKey, "Image");
		pTempChange = new SystemDefaultFileExtTempChange("Image");
		///------ End SYSTEM_DEFAULT_FILE_EXTENSION_TEMP_CHANGE_SUPPORT
	}

	~GetDefaultImageTypeHelper()
	{
		///------ Folger 10/28/09 QA81-14541 SYSTEM_DEFAULT_FILE_EXTENSION_TEMP_CHANGE_SUPPORT
		//m_os.SetValue(m_strActiveGroupKey, m_strActiveGroup);
		delete pTempChange;
		///------ End SYSTEM_DEFAULT_FILE_EXTENSION_TEMP_CHANGE_SUPPORT
	}

	int		GetDefault()
	{
		int			nValue;
		string		strType;
		string		str;
		m_os.GetValue("FILEEXT.DEFTYPE", nValue);
		strType.Format("FILEEXT.TYPE%d", nValue);
		m_os.GetValue(strType, str);
		str = str.Mid(str.ReverseFind('.') + 1);
		str.MakeUpper();
		/// str holds the extension, like BMP
		for ( int ii=0; ii<m_vsTypes.GetSize(); ++ii )
		{
			m_vsTypes[ii].MakeUpper();
			if ( m_vsTypes[ii].Find(str) >= 0 )
				return ii;
		}

		return 5;		/// default EPS
	}

private:

	string			m_strActiveGroupKey;
	OriginSettings	m_os;
	string			m_strActiveGroup;
	vector<string>	m_vsTypes;
	///------ Folger 10/28/09 QA81-14541 SYSTEM_DEFAULT_FILE_EXTENSION_TEMP_CHANGE_SUPPORT
	SystemDefaultFileExtTempChange*	pTempChange;
	///------ End SYSTEM_DEFAULT_FILE_EXTENSION_TEMP_CHANGE_SUPPORT
};

static	void	_init_default_image_type(TreeNode& trGetN)
{
	string			strTypes;
	vector<string>	vsTypes;
	trGetN.type.GetAttribute(STR_COMBO_ATTRIB, strTypes);
	strTypes.GetTokens(vsTypes, '|');

	GetDefaultImageTypeHelper		clHelper(vsTypes);
	trGetN.type.nVal = clHelper.GetDefault();
}

static	void	_check_init_default_image_type(TreeNode& trGetN)
{
	TreeNode	trType = trGetN.type;
	if ( 1 == octree_get_auto_support(&trType) )
	{
		octree_set_auto_support(&trType, 0);		/// Folger 11/16/09 It's OK to remove auto after init
		_init_default_image_type(trGetN);
	}
}
///------ End EXPORT_GRAPH_SUPPORT_READ_DEFAULT_IMAGE_TYPE_FROM_TOOLS_OPTION

static void _init_page_settings_def(TreeNode& trGetN)
{
	OriginSettings os;
	int temp;
	
	//------ Folger 02/03/08 QA80-11008 CHECK_TREENODE_AUTO_ATTRRIBUTE_BEFORE_UPDATE_VALUE
	if ( trGetN.tr.Margin.nVal < 0 )
	{
	//------
	os.GetValue("CopyPage.Closeness", temp);
	trGetN.tr.Margin.nVal=temp;
	//------ Folger 02/03/08 QA80-11008 CHECK_TREENODE_AUTO_ATTRRIBUTE_BEFORE_UPDATE_VALUE
	}
	//------
	
	//------ Folger 02/03/08 QA80-11008 CHECK_TREENODE_AUTO_ATTRRIBUTE_BEFORE_UPDATE_VALUE
	if ( trGetN.tr.BorderWid.nVal < 0 )
	{
	//------
	os.GetValue("CopyPage.ClipBorderw",temp );
	trGetN.tr.BorderWid.nVal=temp;
	//------ Folger 02/03/08 QA80-11008 CHECK_TREENODE_AUTO_ATTRRIBUTE_BEFORE_UPDATE_VALUE
	}
	//------
	
	os.GetValue("CopyPage.ADVKEEPSIZE", temp);
	trGetN.tr.Advanced.Resolution.nVal=temp;
	
	os.GetValue("CopyPage.ADVRES", temp);
	trGetN.tr.Advanced.DPI.nVal = temp;
	
	double	dRatio;
	os.GetValue("CopyPage.RATIO", dRatio);
	trGetN.tr1.Width.SetAttribute(STR_RATIO_ATTRIB, dRatio);	 
	
	///---Sim 08-22-2007 SHOW_CURRENT_SIZE_WHEN_CHANGE_PERCENT
	// this is for initialize default width or height as margin setting
	// DPI not ready, comment out the code
	/*
	GraphPageBase 	gpSource;	
	if( _get_source_page(trGetN, gpSource) )
	{
		TreeNode 	trUnit = tree_get_node_by_id(trGetN, PAGE_UNIT, true);
		TreeNode 	trRescaling = tree_get_node_by_id(trGetN, PAGE_RESCALING, true);
		TreeNode 	trWidth = tree_get_node_by_id(trGetN, PAGE_WIDTH, true);
		TreeNode 	trHeight = tree_get_node_by_id(trGetN, PAGE_HEIGHT, true);
		
		int nUnit = trUnit.nVal;
		
		if ( UNIT_RATIO == nUnit )
		{
			trWidth.dVal = 100;
		}
		else
		{
			double dValueInches;
			double dValue;
			
			bool bWidth = (0 == trRescaling.nVal);
			
			if ( _compute_page_export_inch(gpSource, trGetN, (100/100), dValueInches, bWidth) )
			{
				dValue =  _convert_size_to_specified_unit(dValueInches, UNIT_INCH, nUnit, nDPI);
				dValue *= (dRatio/100);
				if ( bWidth )
					trWidth.dVal = dValue;
				else
					trHeight.dVal = dValue;					
			}
		}
	}
	*/
	///---END SHOW_CURRENT_SIZE_WHEN_CHANGE_PERCENT
}

static bool _gui_update_size_node_enable_on_rescaling(TreeNode& trPageSettings)
{
	if( !trPageSettings )
		return false;
	
	TreeNode 	trWidth = trPageSettings.Width;
	TreeNode 	trHeight = trPageSettings.Height;
	TreeNode 	trRescaling = trPageSettings.Rescaling;
	if( !trWidth || !trHeight || !trRescaling)
		return false;
	
	if( rescaling_width == trRescaling.nVal)
	{
		trWidth.Enable = true;
		trHeight.Enable = false;
	}
	else
	{
		trWidth.Enable = false;
		trHeight.Enable = true;
	}
	return true;	
}

static bool _gui_rescaling_event(TreeNode& myTree, int nRow, int nCol, TreeNode& trNode, DWORD dwCntrl, int nType, WndContainer& theDlg)
{
	TreeNode trPageSettings = trNode.Parent();
	return _gui_update_size_node_enable_on_rescaling(trPageSettings);
}

static bool _gui_unit_event(TreeNode& myTree, int nRow, int nCol, TreeNode& trNode, DWORD dwCntrl, int nType, WndContainer& theDlg)
{
	TreeNode 	trPageSettings = trNode.Parent();
	TreeNode 	trWidth = trPageSettings.Width;
	TreeNode 	trHeight = trPageSettings.Height;
	TreeNode 	trRescaling = trPageSettings.Rescaling;
	TreeNode 	trCurrentSize = trPageSettings.CurrentSize;
	if( !trWidth || !trHeight || !trRescaling)
		return false;
	
	int		nUnit = trNode.nVal;
	if(GUI_UNIT_RATIO == nUnit)
	{
		trWidth.SetAttribute(STR_LABEL_ATTRIB, _L("Ratio(%)"));
		trWidth.Enable = true;
		trRescaling.Show = false;
		trHeight.Show = false;
		
		trCurrentSize.Show = true;
	}
	else
	{
		trWidth.SetAttribute(STR_LABEL_ATTRIB, _L("Fit Width"));
		trRescaling.Show = true;
		trHeight.Show = true;
		_gui_update_size_node_enable_on_rescaling(trHeight.Parent());
		
		trCurrentSize.Show = false;
	}
	return true;
	
}

static void 	_gui_construct_page_size_settings(TreeNode& tr)
{
	GETN_USE(tr)
	
	GETN_CHECK(KeepPreview, _L("Keep Preview Graph"), 0) GETN_ID(PAGE_KEEP_PREVIEW)
	tr.KeepPreview.Show = 0; /// Iris 02/05/2007 v8.0554 REMOVE_BY_MAX_SUGGESTION
	
	GETN_STR(ActualSize, _L("Original Page Size"), _L(""))  GETN_READ_ONLY ///---Sim 08-22-2007 CHANGE_LABEL
	GETN_STR(CurrentSize, _L("Current Size"), _L("")) GETN_ID(PAGE_CUR_SIZE) GETN_READ_ONLY ///---Sim 08-22-2007 SHOW_CURRENT_SIZE_WHEN_CHANGE_PERCENT

	GETN_LIST(Unit, _L("Specify Size in:"), 0, _L("inch|cm|pixel|page ratio")) GETN_ID(PAGE_UNIT) GETN_OPTION_EVENT_EX(_gui_unit_event)
	GETN_LIST(Rescaling, _L("Rescaling"), 0, _L("Width|Height")) GETN_ID(PAGE_RESCALING)  GETN_OPTION_EVENT_EX(_gui_rescaling_event)
	GETN_NUM(Width, _L("Fit Width"), 0)	GETN_ID(PAGE_WIDTH)
	GETN_NUM(Height, _L("Fit Height"), 0)	GETN_ID(PAGE_HEIGHT)  GETN_READ_ONLY
	
	GETN_STR(PixelSize, _L("Pixel Size"), _L(""))  GETN_ID(PAGE_PIXEL_SIZE) GETN_READ_ONLY
}	

static void _gui_construct_type_list(TreeNode& trGetN, const StringArray &vsImageTypeDescriptions)
{
	trGetN.type.Show = true;
	TreeNode	trShow = trGetN.type;
	int			nTypeCtrl = IFT_RASTER_AND_VECTOR;
	string 			strTypes;
	vector<string> 	vsTypes;
	vsTypes = vsImageTypeDescriptions;
	strTypes.SetTokens(vsTypes, '|');
	trShow.SetAttribute(STR_COMBO_ATTRIB, strTypes);	
}


static void _gui_update_path_attributes(TreeNode& trGetN)
{
	//int			nType = _gui_get_image_type(trGetN); /// Hong 10/19/07 v8.0728 IMPROVE_AND_CENTRALIZE_CODE
	
	if ( !_is_theme_applied(trGetN) && trGetN.path.strVal.IsEmpty() )
	{
			trGetN.path.strVal = GetAppPath(FALSE);
	}
	
	TreeNode 	trPath = trGetN.path;	
	tree_set_browse_combo_attrib(trPath);
	tree_set_browse_combo_attrib(trPath, NULL, true, false); /// Hong 10/26/07 QA80-10364 PATH_CTRL_SHOULD_NOT_APEEND_FILENAME
}

/// Hong 07/21/09 QA80-13280-P4 WKS_EXPORT_MULTIPAGE_PDF_PAGE_BREAKS
//static void _gui_init_filename_list(TreeNode& trGetN)
static void _gui_init_filename_list(TreeNode& trGetN, LPCSTR lpcszPredefinedFileName)
/// end WKS_EXPORT_MULTIPAGE_PDF_PAGE_BREAKS
{
	///---Sim 12-23-2008 QA80-12836 SUPPORT_FILE_BROWSER_BUTTON
	/*
	string 	strList;
	if( !trGetN.filename.GetAttribute(STR_COMBO_ATTRIB, strList) )
	{
		/// Hong 11/09/07 v8.0744 MORE_LOCALIZED_WITH_E_VERSION_NEEDED
		//strList = "|<Long Name>|<Short Name>|Graph##";
		strList = "|" + STR_LONG_NAME + "|" + STR_SHORT_NAME + "|" + _L("Graph##");
		/// end MORE_LOCALIZED_WITH_E_VERSION_NEEDED
		trGetN.filename.SetAttribute(STR_COMBO_ATTRIB, strList);
	}
	//------ Folger 12/05/07 LOCALIZED_COMBO_STRING_DEFAULT_SELECTION
	if (trGetN.filename.strVal.IsEmpty())
		trGetN.filename.strVal = strList.GetToken(1, '|');
	//------
	*/
	vector<string> vsFiles;
	vsFiles.Add(STR_LONG_NAME);
	vsFiles.Add(STR_SHORT_NAME);
	/// Hong 07/21/09 QA80-13280-P4 WKS_EXPORT_MULTIPAGE_PDF_PAGE_BREAKS
	//vsFiles.Add(_L("Graph##"));
	vsFiles.Add(lpcszPredefinedFileName);
	/// end WKS_EXPORT_MULTIPAGE_PDF_PAGE_BREAKS
	tree_set_file_browse_combo_attrib(trGetN.filename, vsFiles);
	trGetN.filename.SetAttribute(STR_DLG_OPTIONS_ATTRIB, FDLG_SUPPRESS_WARNING_SAVE_TO_EXISTING);
	trGetN.filename.SetAttribute(STR_BROWSER_FILE_NAME_WITHOUT_EXT, 1);
	if ( trGetN.filename.strVal.IsEmpty() && vsFiles.GetSize() > 0 )
		trGetN.filename.strVal = vsFiles[0];
	///---END QA80-12836 SUPPORT_FILE_BROWSER_BUTTON
}

static void _gui_update_page_settings(TreeNode &trGetN, LPCSTR lpcszExt)
{	
	bool 	bIsDot;

	if( is_image_file_type_ext(lpcszExt, IFT_RASTER) )
		bIsDot = true;
	else if( is_image_file_type_ext(lpcszExt, IFT_VECTOR) )
		bIsDot = false;
	else
		return; //invalid type	
	
	TreeNode 	trPageSettings =  trGetN.tr;
	trPageSettings.Advanced.Show = !bIsDot;
 
 	TreeNode 	trMargin = trPageSettings.Margin;
	TreeNode 	trBorderWid = trPageSettings.BorderWid;
	if( trMargin && trBorderWid)
	{		
		trBorderWid.Enable = 0 == trMargin.nVal? true : false; //0: Border, 1: Tight, 2: Page	
	}	
 	
}

/// Hong 04/17/09 QA80-13280 SUPPORT_EXPORT_MULTI_PAGES_PDF
static string	_get_additional_attrib_name(LPCSTR lpcszExt)
{
	string		strAttrib = (string)lpcszExt + "_Additional";
	strAttrib.MakeUpper();
	return strAttrib;
}

static TreeNode get_additional_options(TreeNode& tr, LPCSTR lpcszExt)
{
	if ( !tr )
	{
		TreeNode	trPDFAdditional;
		return trPDFAdditional;
	}

	return tr.FindNodeByAttribute(_get_additional_attrib_name(lpcszExt), lpcszExt, false);;
}
/// end SUPPORT_EXPORT_MULTI_PAGES_PDF
	
static void gui_after_type_changed(TreeNode &trGetN, LPCSTR lpcszExt)
{
	export_gui_show_options_branch(trGetN.tr2, lpcszExt);
	/// Hong 04/17/09 QA80-13280 SUPPORT_EXPORT_MULTI_PAGES_PDF
	TreeNode		trAdditional = get_additional_options(trGetN.tr2, lpcszExt);
	if ( trAdditional )
		trAdditional.Show = 1;
	/// end SUPPORT_EXPORT_MULTI_PAGES_PDF
	/// Hong 06/17/09 QA80-13280 EXPORT_MULTI_PAGES_PDF_MORE_PRINT_OPTIONS
#ifdef		SUPPORT_EXPORT_MULTI_PAGES_PDF
	if ( trGetN.tr2.Print )
		trGetN.tr2.Print.Show = TRUE;
#endif		//SUPPORT_EXPORT_MULTI_PAGES_PDF
	/// end EXPORT_MULTI_PAGES_PDF_MORE_PRINT_OPTIONS

	_gui_update_page_settings(trGetN, lpcszExt);	
}

// need remove
static bool _gui_convert_standard_str_to_page_name(TreeNode& trGetN)
{
	//convert <active> to real page name
	if( PDS_ACTIVE == okutil_cvt_str_to_predefined_type(trGetN.pages.strVal) )
	{
		Page pg = Project.Pages(-1);
		if( pg )
		{
			if(EXIST_PLOT == pg.GetType())
				trGetN.pages.strVal = pg.GetName();
			else if(EXIST_WKS == pg.GetType() && OPTION_ACTIVE_PAGE == trGetN.export.nVal)
				trGetN.pages.strVal = pg.GetName();
			else
				trGetN.pages.strVal = "";
		}
		else
			return false;
	}
	return true;
}


// should move to a centrlize place later
static bool _is_theme_applied(const TreeNode& trGetN)
{
	int nRet = xf_is_theme_applied(trGetN);
	
	///---Sim 09-05-2008 CLEAN_DEFAULT_THEME
	//if ( THEME_NONE == nRet || THEME_FACTORY_DEFAULT == nRet )
	if ( THEME_NONE == nRet )
	///---END CLEAN_DEFAULT_THEME
		return false;
	return true;
}

static TreeNode _get_xf_var_treenode(TreeNode tr)
{
	TreeNode trVar = tr;
	
	int nVal;
	while ( trVar && !trVar.GetAttribute(STR_XF_VAR_TYPE_ATTRIB, nVal))
	{
		trVar = trVar.Parent();
	}
	
	return trVar;
}
static bool _is_image_relative_setting(TreeNode tr)
{
	TreeNode trVar = _get_xf_var_treenode(tr);
	if ( trVar )
	{
		string strNodeName = trVar.tagName;
		if ( "tr" == strNodeName ) // export setting tree
			return true;
		if ( "tr1" == strNodeName ) // page size tree
			return true;
		if ( "tr2" == strNodeName ) // image setting tree
			return true;
	}
	
	return false;
}

static int _gui_get_image_type(TreeNode& trGetN)
{
	return trGetN.type.nVal;
}


static void _init_theme_list(TreeNode& trTheme)	
{
	/// Hong 12/25/07 b8.0775 FIX_EXPWKS_FAIL_WHEN_SWITCH_THEME
	if ( !trTheme )
		return ;
	/// end FIX_EXPWKS_FAIL_WHEN_SWITCH_THEME
	init_theme_list(trTheme);
	string strCombo;
	trTheme.GetAttribute(STR_COMBO_ATTRIB, strCombo);
	//strCombo.Insert(0, "<Original>|");
	strCombo.Insert(0, STR_DEFAULT_THEME + "|"); /// Hong 10/19/07 v8.0728 IMPROVE_AND_CENTRALIZE_CODE
	trTheme.SetAttribute(STR_COMBO_ATTRIB, strCombo);
	//trTheme.strVal = "<Original>";
	//------ Folger 11/23/07 SHOULD_NOT_ALWAYS_SPECIFY_THE_FIRST_SELECTION
	//trTheme.strVal = STR_DEFAULT_THEME; /// Hong 10/19/07 v8.0728 IMPROVE_AND_CENTRALIZE_CODE
	if (trTheme.strVal.IsEmpty())
		trTheme.strVal = strCombo.GetToken(0, '|');
	//------
}
static bool	_gui_apply_theme(LPCSTR lpcszTheme, PageBase& pg)
{
	/// Hong 10/19/07 v8.0728 IMPROVE_AND_CENTRALIZE_CODE
	if ( !pg )
		return false;
	/// end IMPROVE_AND_CENTRALIZE_CODE
	
	string 	strTheme(lpcszTheme);
	/// Hong 03/03/08 v8.0816 IMPROVE_CODE_MORE_VALID_CHECK_THEME_APPLY	
	if ( strTheme.IsEmpty() )
		return false;
	/// end IMPROVE_CODE_MORE_VALID_CHECK_THEME_APPLY
	//if( 0 != lstrcmp(strTheme, "<Original>") )
	/// Hong 11/09/07 v8.0744 MORE_LOCALIZED_WITH_E_VERSION_NEEDED
	//if( 0 != lstrcmp(strTheme, STR_DEFAULT_THEME) ) /// Hong 10/19/07 v8.0728 IMPROVE_AND_CENTRALIZE_CODE	
	if( !compare_string_localization(strTheme, STR_DEFAULT_THEME_E) )		
	/// end MORE_LOCALIZED_WITH_E_VERSION_NEEDED
	{
		string strSubFolder = "Themes\\Graph\\" + strTheme + ".OTH";
		
		string strFile = GetAppPath(1) + strSubFolder;
		if(!strFile.IsFile())
			strFile = GetAppPath(0) + strSubFolder;
		/// Hong 03/03/08 v8.0816 IMPROVE_CODE_MORE_VALID_CHECK_THEME_APPLY
		if ( !strFile.IsFile() )
			return false;
		/// end IMPROVE_CODE_MORE_VALID_CHECK_THEME_APPLY
		return pg.ApplyFormat(strFile);						
	}
	return true;
}

static string _get_file_name_with_prefix(LPCSTR lpcszPrefix, int index, int numOfPostfix)
{
	string	strPrefix(lpcszPrefix);
	if(numOfPostfix <= 0 || index < 0)
		return strPrefix;
	
	string 	strIndex = index+1; //the index of filename start from 1 
	int		nSpace = numOfPostfix - strIndex.GetLength();
	
	string 	str;
	for(int ii=0; ii<nSpace; ii++)
	{
		str += "0";
	}
	str = (string)lpcszPrefix + str + strIndex;
	return str;
}
static string _get_absolute_file_name(LPCSTR lpcszFilename, LPCSTR lpcszPage, int nIndex)
{
	string	strFilename;
	
	int 	nType = okutil_cvt_str_to_predefined_type(lpcszFilename);
	if(PDS_SHORT_NAME == nType)
	{
		strFilename = lpcszPage;
	}
	else if(PDS_LONG_NAME == nType)
	{		
		Page pg(lpcszPage);
		if(pg)
		{
			strFilename = pg.GetLongName();
			if(strFilename.IsEmpty())
				strFilename = pg.GetName(); //get short name if long name is empty
		}
		/// Iris 08/29/2007 QA70-10302 SUPPORT_EXPORT_WKS
		else 
		{
			strFilename = lpcszPage;			
		}
		///end SUPPORT_EXPORT_WKS
	}
	else
	{
		string	strFilenamePrefix(lpcszFilename);
		int 	numOfPostfix = strFilenamePrefix.GetLength();
		strFilenamePrefix.TrimRight('#');
		numOfPostfix = numOfPostfix - strFilenamePrefix.GetLength();
		strFilename = _get_file_name_with_prefix(strFilenamePrefix, nIndex, numOfPostfix);
	}
	
	if( strFilename.IsEmpty() )
	{
		strFilename = "None";
	}
	else
	{
		strFilename.Remove('"');
	}
	
	return strFilename;
}
///---Sim 09-29-2009 QA80-14386-P3 AUTO_RENAME_JUST_NEED_ASK_ONE_TIMES
//static string _check_get_full_path(LPCSTR lpcszFilenameType, LPCSTR lpcszExt, const string& path, string& strPage, int index, int nOverwrite = c_overwrite_replace)
static string _check_get_full_path(LPCSTR lpcszFilenameType, LPCSTR lpcszExt, const string& path, string& strPage, int index, int& nOverwrite)
///---END QA80-14386-P3 AUTO_RENAME_JUST_NEED_ASK_ONE_TIMES
{	
	string	strFilename;
	strFilename = _get_absolute_file_name(lpcszFilenameType, strPage, index);
		
	bool	bAutoCorrect = true;
	is_str_valid_for_filename(strFilename, bAutoCorrect);
	
	string	strFullPath = path;	
	strFullPath = cvt_predefined_path_to_real_path(strFullPath);
	///------ Folger 05/12/09 QA80-13571-P1-P2 EXPORT_GRAPH_WITH_VERY_LONG_PATH_CRASH_ORIGIN
	//strFullPath.TrimRight('\\');
	//strFullPath += "\\" + strFilename + "." + (string)lpcszExt;	
	check_add_ending_char(strFullPath, '\\');
	strFullPath += strFilename;
	const	int		nMaxFullPathWithoutExt = MAXFULLPATH - (MAX_FILENAME - MAXFULLPATH);
	check_trim_file_path_if_too_long(strFullPath, nMaxFullPathWithoutExt);
	add_file_extension(strFullPath, lpcszExt);
	///------ End EXPORT_GRAPH_WITH_VERY_LONG_PATH_CRASH_ORIGIN
	
	///------ Folger 05/12/09 QA80-13571-P1-P2 EXPORT_GRAPH_WITH_VERY_LONG_PATH_CRASH_ORIGIN
	/////---Sim 05-07-2009 QA80-13571 FIX_CRASH_WHEN_FILE_PATH_LENGTH_IS_TOO_LONG
//#ifdef CHECK_EXCEED_FILE_PATH_LENGTH_LIMITATION
	//check_trim_file_path_if_too_long(strFullPath);
//#endif
	/////---END QA80-13571 FIX_CRASH_WHEN_FILE_PATH_LENGTH_IS_TOO_LONG
	///------ End EXPORT_GRAPH_WITH_VERY_LONG_PATH_CRASH_ORIGIN
	if ( strFullPath.IsFile() )
	{
		///---Sim 09-29-2009 QA80-14386-P3 AUTO_RENAME_JUST_NEED_ASK_ONE_TIMES
		int nCurrentOverwrite = nOverwrite;
		//if ( c_overwrite_ask == nOverwrite )
		if ( c_overwrite_ask == nCurrentOverwrite )
		///---END QA80-14386-P3 AUTO_RENAME_JUST_NEED_ASK_ONE_TIMES
		{
			string strDesc;
			/// Hong 10/31/07 v8.0737 LOCALIZE_WITH_DLL_STR
			//strDesc = _L("Destination file already exists:");
			//strDesc += "\n";
			//strDesc += strFullPath;
			//strDesc += "\n\n";
			//strDesc += "Would you like to replace the file?";
			//strDesc += "\n";
			//strDesc += _L("Yes: \tReplace\nNo: \tAuto Rename\nCancel: \tSkip");			
			ocu_load_msg_str(CER_REPLACE_EXISTING_FILE, &strDesc, strFullPath);
			/// end LOCALIZE_WITH_DLL_STR
			
			int nRet = MessageBox(GetWindow(), strDesc, _L("File Exists!"), MB_YESNOCANCEL|MB_ICONQUESTION);

			///---Sim 09-29-2009 QA80-14386-P3 AUTO_RENAME_JUST_NEED_ASK_ONE_TIMES
			//switch ( nRet )
			//{
			//case IDYES:
				//nOverwrite = c_overwrite_replace;
				//break;
			//case IDNO:
				//nOverwrite = c_overwrite_rename;
				//break;
			//default:
				//nOverwrite = c_overwrite_skip;
				//break;
			//}
			switch ( nRet )
			{
			case IDYES:
				nOverwrite = nCurrentOverwrite = c_overwrite_replace; // to All
				break;
			case IDNO:
				nOverwrite = nCurrentOverwrite = c_overwrite_rename; // to All
				break;
			default:
				nOverwrite = nCurrentOverwrite = c_overwrite_cancel;
				break;
			}
			///---END QA80-14386-P3 AUTO_RENAME_JUST_NEED_ASK_ONE_TIMES
				
		}
		
		///---Sim 09-29-2009 QA80-14386-P3 AUTO_RENAME_JUST_NEED_ASK_ONE_TIMES
		//switch ( nOverwrite )
		switch ( nCurrentOverwrite )
		///---END QA80-14386-P3 AUTO_RENAME_JUST_NEED_ASK_ONE_TIMES
		{
		case c_overwrite_rename:
			get_next_file_name(strFullPath);
			break;
		case c_overwrite_replace:
			// keep file name
			break;
		case c_overwrite_skip:
		case c_overwrite_cancel: ///---Sim 09-29-2009 QA80-14386-P3 AUTO_RENAME_JUST_NEED_ASK_ONE_TIMES
		default:
			strFullPath.Empty();
			break;
		}
	}	
	
	return strFullPath;
}

static bool _check_no_duplicate_names(TreeNode& trGetN)
{
	if ( c_overwrite_rename == trGetN.overwrite.nVal )
	{
		int ii;
		vector<string>	vsPages;		
		string		strPages = get_page_short_name_from_page_list(trGetN.pages.strVal, STR_PAGE_LIST_SEPARATOR, -1);
		int 		numPages = strPages.GetTokens(vsPages, STR_PAGE_LIST_SEPARATOR);
	
		for ( ii = 0; ii < numPages; ii++ )
		{
			vsPages[ii] = _get_absolute_file_name(trGetN.filename.strVal, vsPages[ii], ii);
		}
		
		for ( ii = 0; ii < numPages - 1; ii++ )
		{
			if ( vsPages.Find(vsPages[ii], ii+1) >= 0 )
			{
				return false;
			}		
		}
	}
	
	return true;
}

static bool _gui_check_size_node(TreeNode& trPageSettings, string& strErrMsg, bool& bEnableOK)
{
	double	dWidth = trPageSettings.Width.dVal;
	int		nUnit = trPageSettings.Unit.nVal;
	if(GUI_UNIT_RATIO != nUnit && dWidth <= 0)
	{
		strErrMsg = CER_MUST_LARGE_THAN_0;
		strErrMsg += ":Width";
		bEnableOK = false;
		return false;
	}	

	if(GUI_UNIT_RATIO == nUnit && dWidth <= 0)
	{
		strErrMsg = CER_VALUE_MUST_BE_PERCENT;
		bEnableOK = false;
		return false;
	}	
	
	return true;
}


static void _gui_check_filename(TreeNode& trGetN, string& strErrMsg, bool& bOKEnable)
{
	string 	strFilename = trGetN.filename.strVal;
	int 	nType = okutil_cvt_str_to_predefined_type(strFilename);
	if(PDS_SHORT_NAME != nType && PDS_LONG_NAME != nType)
	{
		strFilename.TrimRight('#');
		if( !is_str_valid_for_filename(strFilename) )
		{
			strErrMsg = CER_INVALID_FILENAME;
			bOKEnable = false;
		}
	}
}

static void _gui_check_update_path(TreeNode& trGetN, string* pstrMessage = NULL, bool* pbOKEnable = NULL)
{
	string 		strPath = trGetN.path.strVal;
	if( is_empty_or_unassigned(strPath) )
	{
		trGetN.path.strVal = GetAppPath();
		return;
	}
	check_relative_path(strPath, true, pstrMessage, pbOKEnable);
}

static CGraphicalExportPageEx* 	s_pGraphExport = NULL;

///Kyle 11/13/2008 QA80-12528 SUPPORT_APPLY_BUTTON_IN_EXPORT_GRAPH_DIALOG
static bool s_bHasBeenApplied = false;
///End SUPPORT_APPLY_BUTTON_IN_EXPORT_GRAPH_DIALOG

// right now, we assume whether support theme option to determine export graph or worksheet,
// if later design change, this function need update.
/**$
	return:
		whether export graph and layout or export worksheet
*/
static bool is_export_page(LPCSTR lpcszTheme)
{
	return ( NULL == lpcszTheme ) ? false : true;
}

static bool is_export_page(TreeNode& trTheme)
{
	LPCSTR lpcszTheme = NULL;
	if ( trTheme )
		lpcszTheme = trTheme.strVal;
		
	return is_export_page(lpcszTheme);
}

static void check_create_exp_object(bool bExportGraph)
{	
	if ( NULL != s_pGraphExport )
		return ;
	
	if ( bExportGraph )
	{
		s_pGraphExport = new CGraphicalExportGraphEx;		
	}	
	else
	{
		s_pGraphExport = new CGraphicalExportWksEx;		
	}
}


static void safe_release_exp_object()
{
	if ( NULL == s_pGraphExport )
		return ;
	
	delete s_pGraphExport;
	s_pGraphExport = NULL;
}

/// Hong 04/17/09 QA80-13280 SUPPORT_EXPORT_MULTI_PAGES_PDF
//void InvokeExpGraph(int nType, int nExport, LPCSTR lpcszPages, LPCSTR lpcszFilename, LPCSTR lpcszPath, int nOverwriteOpt, bool bSysOpts, 
//			const TreeNode& trPageOpts, bool bKeepSize, const TreeNode& trPageSize, const TreeNode& trImageOptions, LPCSTR lpcszTheme) // = NULL
void InvokeExpGraph(int nType, int nExport, LPCSTR lpcszPages, LPCSTR lpcszFilename, LPCSTR lpcszPath, int nOverwriteOpt, bool bSysOpts, 
			const TreeNode& trPageOpts, bool bKeepSize, const TreeNode& trPageSize, const TreeNode& trImageOptions, LPCSTR lpcszTheme/* = NULL*/, bool bMultiPgPDF/* = false*/)
/// end SUPPORT_EXPORT_MULTI_PAGES_PDF
{
	///Kyle 11/13/2008 QA80-12528 SUPPORT_APPLY_BUTTON_IN_EXPORT_GRAPH_DIALOG
	if(s_bHasBeenApplied)
		return;
	s_bHasBeenApplied = true;
	///End SUPPORT_APPLY_BUTTON_IN_EXPORT_GRAPH_DIALOG
	check_create_exp_object( is_export_page(lpcszTheme) );
	
	// initial setting
	s_pGraphExport->SetPageOptions(trPageOpts);
	s_pGraphExport->SetPageSize(trPageSize);
	s_pGraphExport->SetImageOptions(trImageOptions);
	
	/// Hong 10/27/07 v8.0735 EXPORT_BODY_SHOULD_NOT_DEPENDENT_ON_STATIC_EXP_OBJ
	s_pGraphExport->SetImageType(nType);	
	/// end EXPORT_BODY_SHOULD_NOT_DEPENDENT_ON_STATIC_EXP_OBJ
	int nErrCode = CER_NO_ERROR;	///Sophy 10/18/2010 ORG-1276 PROPER_SHOW_RESULT_MESSAGE_ON_PAGE_EXPORT
	///---Sim 09-21-2009 FIX_OPEN_EXP_WKS_RUNTIME_ERROR_IF_NO_WKS_ACTIVE
	try
	{
	///---END FIX_OPEN_EXP_WKS_RUNTIME_ERROR_IF_NO_WKS_ACTIVE
	/// Hong 04/17/09 QA80-13280 SUPPORT_EXPORT_MULTI_PAGES_PDF
	//s_pGraphExport->InvokeExpGraph(nType, nExport, lpcszPages, lpcszFilename, lpcszPath, nOverwriteOpt, 
	//		bSysOpts, bKeepSize, lpcszTheme);
	s_pGraphExport->InvokeExpGraph(nType, nExport, lpcszPages, lpcszFilename, lpcszPath, nOverwriteOpt, 
			bSysOpts, bKeepSize, lpcszTheme, bMultiPgPDF);
	/// end SUPPORT_EXPORT_MULTI_PAGES_PDF
				
	///---Sim 09-21-2009 FIX_OPEN_EXP_WKS_RUNTIME_ERROR_IF_NO_WKS_ACTIVE
	//safe_release_exp_object();
	}
	catch(int nErr)
	{
		///Sophy 10/18/2010 ORG-1276 PROPER_SHOW_RESULT_MESSAGE_ON_PAGE_EXPORT
		//warning_msg_box(nErr, false, 'E');
		nErrCode = nErr;
		///end PROPER_SHOW_RESULT_MESSAGE_ON_PAGE_EXPORT
	}
	safe_release_exp_object();			
	///---END FIX_OPEN_EXP_WKS_RUNTIME_ERROR_IF_NO_WKS_ACTIVE
	///Sophy 10/18/2010 ORG-1276 PROPER_SHOW_RESULT_MESSAGE_ON_PAGE_EXPORT
	if ( nErrCode != CER_NO_ERROR )
		xf_err(nErrCode);
	///end PROPER_SHOW_RESULT_MESSAGE_ON_PAGE_EXPORT
}

/// Hong 04/17/09 QA80-13280 SUPPORT_EXPORT_MULTI_PAGES_PDF
//int InvokeMakeTree(TreeNode& tr, LPCSTR lpcszVarName, bool bExportPage) // = true
int InvokeMakeTree(TreeNode& tr, LPCSTR lpcszVarName, bool bExportPage/* = true*/, bool bMultiPgPDF/* = false*/)
/// end SUPPORT_EXPORT_MULTI_PAGES_PDF
{
	check_create_exp_object( bExportPage );
	
	/// Hong 04/17/09 QA80-13280 SUPPORT_EXPORT_MULTI_PAGES_PDF
	//return s_pGraphExport->InvokeOnMakeTree(tr, lpcszVarName);
	return s_pGraphExport->InvokeOnMakeTree(tr, lpcszVarName, bMultiPgPDF);
	/// end SUPPORT_EXPORT_MULTI_PAGES_PDF
}

/// Hong 04/13/09 QA80-13280 EXP_SINGLE_WKS_TO_MILTI_PAGES_PDF
//void InvokeBeforeExecute(TreeNode& trGetN, int nGetNDialog, int dwCntrl, int& nRet)
///---Sim 09-21-2009 FIX_OPEN_EXP_WKS_RUNTIME_ERROR_IF_NO_WKS_ACTIVE
// Somebody make mistake on prototype
//void InvokeBeforeExecute(TreeNode& trGetN, int nGetNDialog, int dwCntrl, int& nRet, bool bMultiPgPDF/* = false*/)
void InvokeBeforeExecute(TreeNode& trGetN, int nGetNDialog, int& nRet, int dwCntrl, bool bMultiPgPDF/* = false*/)
///---END FIX_OPEN_EXP_WKS_RUNTIME_ERROR_IF_NO_WKS_ACTIVE
/// end EXP_SINGLE_WKS_TO_MILTI_PAGES_PDF
{
	///Kyle 11/13/2008 QA80-12528 SUPPORT_APPLY_BUTTON_IN_EXPORT_GRAPH_DIALOG
	if(is_xf_startup(nGetNDialog, dwCntrl))
		s_bHasBeenApplied = false;
	///End SUPPORT_APPLY_BUTTON_IN_EXPORT_GRAPH_DIALOG
	check_create_exp_object( is_export_page(trGetN.theme) );
	/// Hong 04/13/09 QA80-13280 EXP_SINGLE_WKS_TO_MILTI_PAGES_PDF
	//s_pGraphExport->InvokeBeforeExecute(trGetN, nGetNDialog, nRet, dwCntrl);	
	s_pGraphExport->InvokeBeforeExecute(trGetN, nGetNDialog, nRet, dwCntrl, bMultiPgPDF);
	/// end EXP_SINGLE_WKS_TO_MILTI_PAGES_PDF
	///---Sim 09-21-2009 FIX_OPEN_EXP_WKS_RUNTIME_ERROR_IF_NO_WKS_ACTIVE
	if ( XFEVT_ABORT == nRet )
		safe_release_exp_object();
	///---END FIX_OPEN_EXP_WKS_RUNTIME_ERROR_IF_NO_WKS_ACTIVE
}

void InvokeInitGrid(TreeNode& trGetN, DWORD& dwUpdateGraph,  DWORD& dwEnables, string& strErrMsg)
{
	check_create_exp_object( is_export_page(trGetN.theme) );
	
	bool bUpdateGraph, bOKEnable = dwEnables & GETNGEVT_OK_ENABLE;
	s_pGraphExport->InvokeOnInitGrid(trGetN, bUpdateGraph, bOKEnable, strErrMsg);
	
	// shoudl be a macro in oc_const.h for easy use
	if ( bUpdateGraph )
		dwUpdateGraph = UPDATE_GRAPH_CHANGED;
	else
		dwUpdateGraph = 0;
	
	if ( bOKEnable )
		dwEnables |= GETNGEVT_OK_ENABLE;
	else
		dwEnables &= ~GETNGEVT_OK_ENABLE;
}

void InvokeInitGraph(TreeNode& trGetN, PageBase& pgTemp, PictureControl& pict,  DWORD& dwEnables, string& strErrMsg)
{
	check_create_exp_object( is_export_page(trGetN.theme) );
	
	bool bOKEnable = dwEnables & GETNGEVT_OK_ENABLE;
	s_pGraphExport->InvokeOnInitGraph(trGetN, pgTemp, pict, strErrMsg, bOKEnable);
	
	if ( bOKEnable )
		dwEnables |= GETNGEVT_OK_ENABLE;
	else
		dwEnables &= ~GETNGEVT_OK_ENABLE;
}

void InvokeUpdateGraph(TreeNode& trGetN, PageBase& pgTemp, Datasheet& wksTemp, PictureControl& pict)
{
	check_create_exp_object( is_export_page(trGetN.theme) );
	
	s_pGraphExport->InvokeOnUpdateGraph(trGetN,  pgTemp, wksTemp, pict);
}

/// Hong 07/21/09 QA80-13280-P4 WKS_EXPORT_MULTIPAGE_PDF_PAGE_BREAKS
//void InvokeOnChange(TreeNode& trGetN, TreeNode& trNode, DWORD& dwUpdateGraph, DWORD& dwEnables, string& strErrMsg)
void InvokeOnChange(TreeNode& trGetN, TreeNode& trNode, DWORD& dwUpdateGraph, DWORD& dwEnables, string& strErrMsg, bool bMultiPgPDF/* = false*/)
/// end WKS_EXPORT_MULTIPAGE_PDF_PAGE_BREAKS
{
	check_create_exp_object( is_export_page(trGetN.theme) );
	
	bool bUpdateGraph, bOKEnable = dwEnables & GETNGEVT_OK_ENABLE;
	/// Hong 07/21/09 QA80-13280-P4 WKS_EXPORT_MULTIPAGE_PDF_PAGE_BREAKS
	//s_pGraphExport->InvokeOnChange(trGetN, trNode, bUpdateGraph, bOKEnable, strErrMsg);
	s_pGraphExport->InvokeOnChange(trGetN, trNode, bUpdateGraph, bOKEnable, strErrMsg, bMultiPgPDF);
	/// end WKS_EXPORT_MULTIPAGE_PDF_PAGE_BREAKS
	
	if ( bUpdateGraph )
		dwUpdateGraph = UPDATE_GRAPH_CHANGED;
	else
		dwUpdateGraph = 0;
	
	if ( bOKEnable )
		dwEnables |= GETNGEVT_OK_ENABLE;
	else
		dwEnables &= ~GETNGEVT_OK_ENABLE;
	
	s_bHasBeenApplied = false;			///Kyle 11/13/2008 QA80-12528 SUPPORT_APPLY_BUTTON_IN_EXPORT_GRAPH_DIALOG
}

void InvokeOnDestroy()
{
	safe_release_exp_object();
}
